/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.net;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.pulsar.shade.com.google.common.base.CharMatcher;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.common.base.Splitter;
import org.apache.pulsar.shade.com.google.common.base.Strings;
import org.apache.pulsar.shade.org.apache.commons.lang.StringUtils;

public class ServiceURI {
    private static final String BINARY_SERVICE = "pulsar";
    private static final String HTTP_SERVICE = "http";
    private static final String HTTPS_SERVICE = "https";
    private static final String SSL_SERVICE = "ssl";
    private static final int BINARY_PORT = 6650;
    private static final int BINARY_TLS_PORT = 6651;
    private static final int HTTP_PORT = 80;
    private static final int HTTPS_PORT = 443;
    private final String serviceName;
    private final String[] serviceInfos;
    private final String serviceUser;
    private final String[] serviceHosts;
    private final String servicePath;
    private final URI uri;

    public static ServiceURI create(String uriStr) {
        Splitter splitter;
        List<String> hosts;
        Preconditions.checkNotNull(uriStr, "service uri string is null");
        if (uriStr.contains("[") && uriStr.contains("]") && (hosts = (splitter = Splitter.on(CharMatcher.anyOf(",;"))).splitToList(uriStr)).size() > 1) {
            String firstHost = hosts.get(0);
            String lastHost = hosts.get(hosts.size() - 1);
            boolean hasPath = lastHost.contains("/");
            String path = hasPath ? lastHost.substring(lastHost.indexOf("/")) : "";
            firstHost = firstHost + path;
            URI uri = URI.create(firstHost);
            ServiceURI serviceURI = ServiceURI.create(uri);
            List<Object> multiHosts = new ArrayList<String>();
            multiHosts.add(serviceURI.getServiceHosts()[0]);
            multiHosts.addAll(hosts.subList(1, hosts.size()));
            multiHosts = multiHosts.stream().map(host -> ServiceURI.validateHostName(serviceURI.getServiceName(), serviceURI.getServiceInfos(), host)).collect(Collectors.toList());
            return new ServiceURI(serviceURI.getServiceName(), serviceURI.getServiceInfos(), serviceURI.getServiceUser(), multiHosts.toArray(new String[multiHosts.size()]), serviceURI.getServicePath(), serviceURI.getUri());
        }
        URI uri = URI.create(uriStr);
        return ServiceURI.create(uri);
    }

    public static ServiceURI create(URI uri) {
        List<String> serviceHosts;
        String serviceUser;
        String[] serviceInfos;
        String serviceName;
        Preconditions.checkNotNull(uri, "service uri instance is null");
        String scheme = uri.getScheme();
        if (null != scheme) {
            scheme = scheme.toLowerCase();
            String serviceSep = "+";
            String[] schemeParts = StringUtils.split(scheme, "+");
            serviceName = schemeParts[0];
            serviceInfos = new String[schemeParts.length - 1];
            System.arraycopy(schemeParts, 1, serviceInfos, 0, serviceInfos.length);
        } else {
            serviceName = null;
            serviceInfos = new String[]{};
        }
        String userAndHostInformation = uri.getAuthority();
        Preconditions.checkArgument(!Strings.isNullOrEmpty(userAndHostInformation), "authority component is missing in service uri : " + uri);
        int atIndex = userAndHostInformation.indexOf(64);
        Splitter splitter = Splitter.on(CharMatcher.anyOf(",;"));
        if (atIndex > 0) {
            serviceUser = userAndHostInformation.substring(0, atIndex);
            serviceHosts = splitter.splitToList(userAndHostInformation.substring(atIndex + 1));
        } else {
            serviceUser = null;
            serviceHosts = splitter.splitToList(userAndHostInformation);
        }
        serviceHosts = serviceHosts.stream().map(host -> ServiceURI.validateHostName(serviceName, serviceInfos, host)).collect(Collectors.toList());
        String servicePath = uri.getPath();
        Preconditions.checkArgument(null != servicePath, "service path component is missing in service uri : " + uri);
        return new ServiceURI(serviceName, serviceInfos, serviceUser, serviceHosts.toArray(new String[serviceHosts.size()]), servicePath, uri);
    }

    private static String validateHostName(String serviceName, String[] serviceInfos, String hostname) {
        URI uri = null;
        try {
            uri = URI.create("dummyscheme://" + hostname);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid hostname : " + hostname);
        }
        String host = uri.getHost();
        if (host == null) {
            throw new IllegalArgumentException("Invalid hostname : " + hostname);
        }
        int port = uri.getPort();
        if (port == -1) {
            port = ServiceURI.getServicePort(serviceName, serviceInfos);
        }
        return host + ":" + port;
    }

    public String[] getServiceInfos() {
        return this.serviceInfos;
    }

    public String[] getServiceHosts() {
        return this.serviceHosts;
    }

    public String getServiceScheme() {
        if (null == this.serviceName) {
            return null;
        }
        if (this.serviceInfos.length == 0) {
            return this.serviceName;
        }
        return this.serviceName + "+" + StringUtils.join((Object[])this.serviceInfos, '+');
    }

    private static int getServicePort(String serviceName, String[] serviceInfos) {
        int port;
        switch (serviceName.toLowerCase()) {
            case "pulsar": {
                if (serviceInfos.length == 0) {
                    port = 6650;
                    break;
                }
                if (serviceInfos.length == 1 && serviceInfos[0].toLowerCase().equals(SSL_SERVICE)) {
                    port = 6651;
                    break;
                }
                throw new IllegalArgumentException("Invalid pulsar service : " + serviceName + "+" + Arrays.toString(serviceInfos));
            }
            case "http": {
                port = 80;
                break;
            }
            case "https": {
                port = 443;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid pulsar service : " + serviceName);
            }
        }
        return port;
    }

    private ServiceURI(String serviceName, String[] serviceInfos, String serviceUser, String[] serviceHosts, String servicePath, URI uri) {
        this.serviceName = serviceName;
        this.serviceInfos = serviceInfos;
        this.serviceUser = serviceUser;
        this.serviceHosts = serviceHosts;
        this.servicePath = servicePath;
        this.uri = uri;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceUser() {
        return this.serviceUser;
    }

    public String getServicePath() {
        return this.servicePath;
    }

    public URI getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceURI)) {
            return false;
        }
        ServiceURI other = (ServiceURI)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$serviceName = this.getServiceName();
        String other$serviceName = other.getServiceName();
        if (this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getServiceInfos(), other.getServiceInfos())) {
            return false;
        }
        String this$serviceUser = this.getServiceUser();
        String other$serviceUser = other.getServiceUser();
        if (this$serviceUser == null ? other$serviceUser != null : !this$serviceUser.equals(other$serviceUser)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getServiceHosts(), other.getServiceHosts())) {
            return false;
        }
        String this$servicePath = this.getServicePath();
        String other$servicePath = other.getServicePath();
        if (this$servicePath == null ? other$servicePath != null : !this$servicePath.equals(other$servicePath)) {
            return false;
        }
        URI this$uri = this.getUri();
        URI other$uri = other.getUri();
        return !(this$uri == null ? other$uri != null : !((Object)this$uri).equals(other$uri));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServiceURI;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serviceName = this.getServiceName();
        result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getServiceInfos());
        String $serviceUser = this.getServiceUser();
        result = result * 59 + ($serviceUser == null ? 43 : $serviceUser.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getServiceHosts());
        String $servicePath = this.getServicePath();
        result = result * 59 + ($servicePath == null ? 43 : $servicePath.hashCode());
        URI $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : ((Object)$uri).hashCode());
        return result;
    }
}

