/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.stats;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.pulsar.shade.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.pulsar.shade.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.NonPersistentPublisherStats;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.NonPersistentReplicatorStats;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.NonPersistentSubscriptionStats;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.NonPersistentTopicStats;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.stats.NonPersistentPublisherStatsImpl;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.stats.NonPersistentReplicatorStatsImpl;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.stats.NonPersistentSubscriptionStatsImpl;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.stats.PublisherStatsImpl;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.stats.ReplicatorStatsImpl;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.stats.SubscriptionStatsImpl;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.stats.TopicStatsImpl;

@SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"})
public class NonPersistentTopicStatsImpl
extends TopicStatsImpl
implements NonPersistentTopicStats {
    public double msgDropRate;
    @JsonIgnore
    public List<PublisherStatsImpl> publishers;
    @JsonIgnore
    public Map<String, SubscriptionStatsImpl> subscriptions;
    @JsonIgnore
    public Map<String, ReplicatorStatsImpl> replication;
    public List<? extends NonPersistentPublisherStats> nonPersistentPublishers = new ArrayList<NonPersistentPublisherStats>();
    public Map<String, ? extends NonPersistentSubscriptionStats> nonPersistentSubscriptions = new HashMap<String, NonPersistentSubscriptionStats>();
    public Map<String, ? extends NonPersistentReplicatorStats> nonPersistentReplicators = new TreeMap<String, NonPersistentReplicatorStats>();

    @JsonProperty(value="publishers")
    public List<NonPersistentPublisherStats> getNonPersistentPublishers() {
        return this.nonPersistentPublishers;
    }

    @JsonProperty(value="subscriptions")
    public Map<String, NonPersistentSubscriptionStats> getNonPersistentSubscriptions() {
        return this.nonPersistentSubscriptions;
    }

    @JsonProperty(value="replication")
    public Map<String, NonPersistentReplicatorStats> getNonPersistentReplicators() {
        return this.nonPersistentReplicators;
    }

    @SuppressFBWarnings(value={"MF_CLASS_MASKS_FIELD"}, justification="expected to override")
    public List<NonPersistentPublisherStats> getPublishers() {
        return this.nonPersistentPublishers;
    }

    @SuppressFBWarnings(value={"MF_CLASS_MASKS_FIELD"}, justification="expected to override")
    public Map<String, NonPersistentSubscriptionStats> getSubscriptions() {
        return this.nonPersistentSubscriptions;
    }

    @SuppressFBWarnings(value={"MF_CLASS_MASKS_FIELD"}, justification="expected to override")
    public Map<String, NonPersistentReplicatorStats> getReplication() {
        return this.nonPersistentReplicators;
    }

    @Override
    public double getMsgDropRate() {
        return this.msgDropRate;
    }

    @Override
    public void reset() {
        super.reset();
        this.nonPersistentPublishers.clear();
        this.nonPersistentSubscriptions.clear();
        this.nonPersistentReplicators.clear();
        this.msgDropRate = 0.0;
    }

    public NonPersistentTopicStatsImpl add(NonPersistentTopicStats ts) {
        NonPersistentReplicatorStatsImpl replStats;
        NonPersistentSubscriptionStatsImpl subscriptionStats;
        int i;
        NonPersistentTopicStatsImpl stats = (NonPersistentTopicStatsImpl)ts;
        Objects.requireNonNull(stats);
        super.add(stats);
        this.msgDropRate += stats.msgDropRate;
        if (this.getNonPersistentPublishers().size() != stats.getNonPersistentPublishers().size()) {
            for (i = 0; i < stats.getNonPersistentPublishers().size(); ++i) {
                NonPersistentPublisherStatsImpl publisherStats = new NonPersistentPublisherStatsImpl();
                this.getNonPersistentPublishers().add(publisherStats.add((NonPersistentPublisherStatsImpl)stats.getNonPersistentPublishers().get(i)));
            }
        } else {
            for (i = 0; i < stats.getNonPersistentPublishers().size(); ++i) {
                ((NonPersistentPublisherStatsImpl)this.getNonPersistentPublishers().get(i)).add((NonPersistentPublisherStatsImpl)stats.getNonPersistentPublishers().get(i));
            }
        }
        if (this.getNonPersistentSubscriptions().size() != stats.getNonPersistentSubscriptions().size()) {
            for (String subscription : stats.getNonPersistentSubscriptions().keySet()) {
                subscriptionStats = new NonPersistentSubscriptionStatsImpl();
                this.getNonPersistentSubscriptions().put(subscription, subscriptionStats.add((NonPersistentSubscriptionStatsImpl)stats.getNonPersistentSubscriptions().get(subscription)));
            }
        } else {
            for (String subscription : stats.getNonPersistentSubscriptions().keySet()) {
                if (this.getNonPersistentSubscriptions().get(subscription) != null) {
                    ((NonPersistentSubscriptionStatsImpl)this.getNonPersistentSubscriptions().get(subscription)).add((NonPersistentSubscriptionStatsImpl)stats.getNonPersistentSubscriptions().get(subscription));
                    continue;
                }
                subscriptionStats = new NonPersistentSubscriptionStatsImpl();
                this.getNonPersistentSubscriptions().put(subscription, subscriptionStats.add((NonPersistentSubscriptionStatsImpl)stats.getNonPersistentSubscriptions().get(subscription)));
            }
        }
        if (this.getNonPersistentReplicators().size() != stats.getNonPersistentReplicators().size()) {
            for (String repl : stats.getNonPersistentReplicators().keySet()) {
                replStats = new NonPersistentReplicatorStatsImpl();
                this.getNonPersistentReplicators().put(repl, replStats.add((NonPersistentReplicatorStatsImpl)stats.getNonPersistentReplicators().get(repl)));
            }
        } else {
            for (String repl : stats.getNonPersistentReplicators().keySet()) {
                if (this.getNonPersistentReplicators().get(repl) != null) {
                    ((NonPersistentReplicatorStatsImpl)this.getNonPersistentReplicators().get(repl)).add((NonPersistentReplicatorStatsImpl)stats.getNonPersistentReplicators().get(repl));
                    continue;
                }
                replStats = new NonPersistentReplicatorStatsImpl();
                this.getNonPersistentReplicators().put(repl, replStats.add((NonPersistentReplicatorStatsImpl)stats.getNonPersistentReplicators().get(repl)));
            }
        }
        return this;
    }
}

