/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.schema;

import java.util.Collections;
import java.util.Map;
import org.apache.pulsar.client.internal.DefaultImplementation;
import org.apache.pulsar.shade.org.apache.pulsar.common.classification.InterfaceAudience;
import org.apache.pulsar.shade.org.apache.pulsar.common.classification.InterfaceStability;
import org.apache.pulsar.shade.org.apache.pulsar.common.schema.SchemaType;

@InterfaceAudience.Public
@InterfaceStability.Stable
public interface SchemaInfo {
    public String getName();

    public byte[] getSchema();

    public SchemaType getType();

    public Map<String, String> getProperties();

    public String getSchemaDefinition();

    public static SchemaInfoBuilder builder() {
        return new SchemaInfoBuilder();
    }

    public static class SchemaInfoBuilder {
        private String name;
        private byte[] schema;
        private SchemaType type;
        private Map<String, String> properties;
        private boolean propertiesSet;

        SchemaInfoBuilder() {
        }

        public SchemaInfoBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SchemaInfoBuilder schema(byte[] schema) {
            this.schema = schema;
            return this;
        }

        public SchemaInfoBuilder type(SchemaType type) {
            this.type = type;
            return this;
        }

        public SchemaInfoBuilder properties(Map<String, String> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        public SchemaInfo build() {
            Map<String, String> propertiesValue = this.properties;
            if (!this.propertiesSet) {
                propertiesValue = Collections.emptyMap();
            }
            return DefaultImplementation.newSchemaInfoImpl(this.name, this.schema, this.type, propertiesValue);
        }
    }
}

