/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import java.nio.ByteBuffer;
import org.apache.pulsar.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.org.apache.commons.codec.binary.Base64;
import org.apache.pulsar.shade.org.apache.commons.codec.binary.Hex;

public class DLSN
implements Comparable<DLSN> {
    public static final byte VERSION0 = 0;
    public static final byte VERSION1 = 1;
    public static final DLSN InitialDLSN = new DLSN(1L, 0L, 0L);
    public static final DLSN NonInclusiveLowerBound = new DLSN(1L, 0L, -1L);
    public static final DLSN InvalidDLSN = new DLSN(0L, -1L, -1L);
    static final byte CUR_VERSION = 1;
    static final int VERSION0_LEN = 200;
    static final int VERSION1_LEN = 25;
    private final long logSegmentSequenceNo;
    private final long entryId;
    private final long slotId;

    public DLSN(long logSegmentSequenceNo, long entryId, long slotId) {
        this.logSegmentSequenceNo = logSegmentSequenceNo;
        this.entryId = entryId;
        this.slotId = slotId;
    }

    public long getLogSegmentSequenceNo() {
        return this.logSegmentSequenceNo;
    }

    public long getEntryId() {
        return this.entryId;
    }

    public long getSlotId() {
        return this.slotId;
    }

    @Override
    public int compareTo(DLSN that) {
        if (this.logSegmentSequenceNo != that.logSegmentSequenceNo) {
            return this.logSegmentSequenceNo < that.logSegmentSequenceNo ? -1 : 1;
        }
        if (this.entryId != that.entryId) {
            return this.entryId < that.entryId ? -1 : 1;
        }
        return this.slotId < that.slotId ? -1 : (this.slotId == that.slotId ? 0 : 1);
    }

    public byte[] serializeBytes() {
        return this.serializeBytes((byte)1);
    }

    public byte[] serializeBytes(byte version) {
        Preconditions.checkArgument(version <= 1 && version >= 0);
        byte[] data = new byte[1 == version ? 25 : 200];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.put(version);
        bb.putLong(this.logSegmentSequenceNo);
        bb.putLong(this.entryId);
        bb.putLong(this.slotId);
        return data;
    }

    public String serialize() {
        return this.serialize((byte)1);
    }

    public String serialize(byte version) {
        return Base64.encodeBase64String(this.serializeBytes(version));
    }

    public static DLSN deserialize(String dlsn) {
        byte[] data = Base64.decodeBase64(dlsn);
        return DLSN.deserializeBytes(data);
    }

    public static DLSN deserializeBytes(byte[] data) {
        ByteBuffer bb = ByteBuffer.wrap(data);
        byte version = bb.get();
        if (0 == version) {
            if (200 != data.length) {
                throw new IllegalArgumentException("Invalid version zero DLSN " + Hex.encodeHexString(data));
            }
        } else if (1 == version) {
            if (25 != data.length) {
                throw new IllegalArgumentException("Invalid version one DLSN " + Hex.encodeHexString(data));
            }
        } else {
            throw new IllegalArgumentException("Invalid DLSN : version = " + version + ", " + Hex.encodeHexString(data));
        }
        return new DLSN(bb.getLong(), bb.getLong(), bb.getLong());
    }

    @VisibleForTesting
    static DLSN deserialize0(String dlsn) {
        byte[] data = Base64.decodeBase64(dlsn);
        ByteBuffer bb = ByteBuffer.wrap(data);
        byte version = bb.get();
        if (0 != version || 200 != data.length) {
            throw new IllegalArgumentException("Invalid DLSN " + dlsn);
        }
        return new DLSN(bb.getLong(), bb.getLong(), bb.getLong());
    }

    public String toString() {
        return "DLSN{logSegmentSequenceNo=" + this.logSegmentSequenceNo + ", entryId=" + this.entryId + ", slotId=" + this.slotId + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DLSN)) {
            return false;
        }
        DLSN dlsn = (DLSN)o;
        if (this.entryId != dlsn.entryId) {
            return false;
        }
        if (this.logSegmentSequenceNo != dlsn.logSegmentSequenceNo) {
            return false;
        }
        return this.slotId == dlsn.slotId;
    }

    public int hashCode() {
        int result = (int)(this.logSegmentSequenceNo ^ this.logSegmentSequenceNo >>> 32);
        result = 31 * result + (int)(this.entryId ^ this.entryId >>> 32);
        result = 31 * result + (int)(this.slotId ^ this.slotId >>> 32);
        return result;
    }

    public DLSN getNextDLSN() {
        return new DLSN(this.logSegmentSequenceNo, this.entryId, this.slotId + 1L);
    }

    public DLSN positionOnTheNextLedger() {
        return new DLSN(this.logSegmentSequenceNo + 1L, 0L, 0L);
    }
}

