/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.LogRecord;
import org.apache.pulsar.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.Unpooled;

public class LogRecordWithDLSN
extends LogRecord {
    private final DLSN dlsn;
    private final long startSequenceIdOfCurrentSegment;

    LogRecordWithDLSN(DLSN dlsn, long startSequenceIdOfCurrentSegment) {
        this.dlsn = dlsn;
        this.startSequenceIdOfCurrentSegment = startSequenceIdOfCurrentSegment;
    }

    @VisibleForTesting
    public LogRecordWithDLSN(DLSN dlsn, long txid, byte[] data, long startSequenceIdOfCurrentSegment) {
        super(txid, data);
        this.dlsn = dlsn;
        this.startSequenceIdOfCurrentSegment = startSequenceIdOfCurrentSegment;
    }

    @VisibleForTesting
    public LogRecordWithDLSN(DLSN dlsn, long txid, ByteBuf buffer, long startSequenceIdOfCurrentSegment) {
        super(txid, Unpooled.copiedBuffer(buffer));
        this.dlsn = dlsn;
        this.startSequenceIdOfCurrentSegment = startSequenceIdOfCurrentSegment;
    }

    long getStartSequenceIdOfCurrentSegment() {
        return this.startSequenceIdOfCurrentSegment;
    }

    public long getSequenceId() {
        return this.startSequenceIdOfCurrentSegment + (long)this.getPositionWithinLogSegment() - 1L;
    }

    public DLSN getDlsn() {
        return this.dlsn;
    }

    public String toString() {
        return "LogRecordWithDLSN{dlsn=" + this.dlsn + ", txid=" + this.getTransactionId() + ", position=" + this.getPositionWithinLogSegment() + ", isControl=" + this.isControl() + ", isEndOfStream=" + this.isEndOfStream() + '}';
    }
}

