/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.pulsar.shade.com.google.common.base.Stopwatch;
import org.apache.pulsar.shade.org.apache.zookeeper.KeeperException;
import org.apache.pulsar.shade.org.apache.zookeeper.WatchedEvent;
import org.apache.pulsar.shade.org.apache.zookeeper.Watcher;
import org.apache.pulsar.shade.org.apache.zookeeper.ZooKeeper;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperClientUtils {
    private static final Logger logger = LoggerFactory.getLogger(ZooKeeperClientUtils.class);

    public static void expireSession(ZooKeeperClient zkc, String zkServers, int timeout) throws Exception {
        final CountDownLatch expireLatch = new CountDownLatch(1);
        final CountDownLatch latch = new CountDownLatch(1);
        ZooKeeper oldZk = zkc.get();
        oldZk.exists("/", new Watcher(){

            @Override
            public void process(WatchedEvent event) {
                logger.debug("Receive event : {}", (Object)event);
                if (event.getType() == Watcher.Event.EventType.None && event.getState() == Watcher.Event.KeeperState.Expired) {
                    expireLatch.countDown();
                }
            }
        });
        ZooKeeper newZk = new ZooKeeper(zkServers, timeout, new Watcher(){

            @Override
            public void process(WatchedEvent event) {
                if (Watcher.Event.EventType.None == event.getType() && Watcher.Event.KeeperState.SyncConnected == event.getState()) {
                    latch.countDown();
                }
            }
        }, oldZk.getSessionId(), oldZk.getSessionPasswd());
        if (!latch.await(timeout, TimeUnit.MILLISECONDS)) {
            throw KeeperException.create(KeeperException.Code.CONNECTIONLOSS);
        }
        newZk.close();
        boolean done = false;
        Stopwatch expireWait = Stopwatch.createStarted();
        while (!done && expireWait.elapsed(TimeUnit.MILLISECONDS) < (long)(timeout * 2)) {
            try {
                zkc.get().exists("/", false);
                done = true;
            }
            catch (KeeperException ke) {
                done = ke.code() == KeeperException.Code.SESSIONEXPIRED;
            }
        }
        Assert.assertTrue((String)"Client should receive session expired event.", (boolean)expireLatch.await(timeout, TimeUnit.MILLISECONDS));
    }
}

