/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.config;

import java.io.File;
import java.util.Optional;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.common.config.ConcurrentConstConfiguration;
import org.apache.distributedlog.common.config.PropertiesWriter;
import org.apache.distributedlog.config.DynamicConfigurationFactory;
import org.apache.distributedlog.config.DynamicDistributedLogConfiguration;
import org.apache.pulsar.shade.com.google.common.base.Objects;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDynamicConfigurationFactory {
    static final Logger LOG = LoggerFactory.getLogger(TestDynamicConfigurationFactory.class);

    private void waitForConfig(DynamicDistributedLogConfiguration conf, int value) throws Exception {
        while (!Objects.equal(conf.getRetentionPeriodHours(), value)) {
            Thread.sleep(100L);
        }
    }

    private DynamicConfigurationFactory getConfigFactory(File configFile) {
        String streamConfigPath = configFile.getParent();
        ScheduledThreadPoolExecutor executorService = new ScheduledThreadPoolExecutor(1);
        ConcurrentConstConfiguration defaultConf = new ConcurrentConstConfiguration(new DistributedLogConfiguration());
        return new DynamicConfigurationFactory(executorService, 100, TimeUnit.MILLISECONDS);
    }

    private String getNamePart(File configFile) {
        String propsFilename = configFile.getName();
        return propsFilename.substring(0, propsFilename.indexOf(".conf"));
    }

    @Test(timeout=60000L)
    public void testGetDynamicConfigBasics() throws Exception {
        PropertiesWriter writer = new PropertiesWriter();
        DynamicConfigurationFactory factory = this.getConfigFactory(writer.getFile());
        Optional<DynamicDistributedLogConfiguration> conf = factory.getDynamicConfiguration(writer.getFile().getPath());
        Assert.assertEquals((long)72L, (long)conf.get().getRetentionPeriodHours());
        writer.setProperty("logSegmentRetentionHours", "1");
        writer.save();
        this.waitForConfig(conf.get(), 1);
        Assert.assertEquals((long)1L, (long)conf.get().getRetentionPeriodHours());
    }

    @Test(timeout=60000L)
    public void testGetDynamicConfigIsSingleton() throws Exception {
        PropertiesWriter writer = new PropertiesWriter();
        DynamicConfigurationFactory factory = this.getConfigFactory(writer.getFile());
        String configPath = writer.getFile().getPath();
        Optional<DynamicDistributedLogConfiguration> conf1 = factory.getDynamicConfiguration(configPath);
        Optional<DynamicDistributedLogConfiguration> conf2 = factory.getDynamicConfiguration(configPath);
        Assert.assertEquals(conf1, conf2);
    }

    @Test(timeout=60000L)
    public void testMissingConfig() throws Exception {
        PropertiesWriter writer = new PropertiesWriter();
        DynamicConfigurationFactory factory = this.getConfigFactory(writer.getFile());
        Optional<DynamicDistributedLogConfiguration> conf = factory.getDynamicConfiguration(writer.getFile().getPath());
        writer.setProperty("logSegmentRetentionHours", "1");
        writer.save();
        this.waitForConfig(conf.get(), 1);
        File configFile = writer.getFile();
        configFile.delete();
        Thread.sleep(1000L);
        PropertiesWriter writer2 = new PropertiesWriter(writer.getFile());
        writer2.setProperty("logSegmentRetentionHours", "2");
        writer2.save();
        this.waitForConfig(conf.get(), 2);
    }
}

