/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.feature;

import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.common.config.PropertiesWriter;
import org.apache.distributedlog.feature.DynamicConfigurationFeatureProvider;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.NullStatsLogger;
import org.junit.Assert;
import org.junit.Test;

public class TestDynamicConfigurationFeatureProvider {
    private void ensureConfigReloaded() throws InterruptedException {
        Thread.sleep(1L);
    }

    @Test(timeout=60000L)
    public void testLoadFeaturesFromBase() throws Exception {
        PropertiesWriter writer = new PropertiesWriter();
        writer.setProperty("feature_1", "10000");
        writer.setProperty("feature_2", "5000");
        writer.save();
        DistributedLogConfiguration conf = new DistributedLogConfiguration().setDynamicConfigReloadIntervalSec(Integer.MAX_VALUE).setFileFeatureProviderBaseConfigPath(writer.getFile().toURI().toURL().getPath());
        DynamicConfigurationFeatureProvider provider = new DynamicConfigurationFeatureProvider("", conf, NullStatsLogger.INSTANCE);
        provider.start();
        this.ensureConfigReloaded();
        Object feature1 = provider.getFeature("feature_1");
        Assert.assertTrue((boolean)feature1.isAvailable());
        Assert.assertEquals((long)10000L, (long)feature1.availability());
        Object feature2 = provider.getFeature("feature_2");
        Assert.assertTrue((boolean)feature2.isAvailable());
        Assert.assertEquals((long)5000L, (long)feature2.availability());
        Object feature3 = provider.getFeature("feature_3");
        Assert.assertFalse((boolean)feature3.isAvailable());
        Assert.assertEquals((long)0L, (long)feature3.availability());
        Object feature4 = provider.getFeature("unknown_feature");
        Assert.assertFalse((boolean)feature4.isAvailable());
        Assert.assertEquals((long)0L, (long)feature4.availability());
        provider.stop();
    }

    public void testLoadFeaturesFromOverlay() throws Exception {
        PropertiesWriter writer = new PropertiesWriter();
        writer.setProperty("feature_1", "10000");
        writer.setProperty("feature_2", "5000");
        writer.save();
        PropertiesWriter overlayWriter = new PropertiesWriter();
        overlayWriter.setProperty("feature_2", "6000");
        overlayWriter.setProperty("feature_4", "6000");
        overlayWriter.save();
        DistributedLogConfiguration conf = new DistributedLogConfiguration().setDynamicConfigReloadIntervalSec(Integer.MAX_VALUE).setFileFeatureProviderBaseConfigPath(writer.getFile().toURI().toURL().getPath()).setFileFeatureProviderOverlayConfigPath(overlayWriter.getFile().toURI().toURL().getPath());
        DynamicConfigurationFeatureProvider provider = new DynamicConfigurationFeatureProvider("", conf, NullStatsLogger.INSTANCE);
        provider.start();
        this.ensureConfigReloaded();
        Object feature1 = provider.getFeature("feature_1");
        Assert.assertTrue((boolean)feature1.isAvailable());
        Assert.assertEquals((long)10000L, (long)feature1.availability());
        Object feature2 = provider.getFeature("feature_2");
        Assert.assertTrue((boolean)feature2.isAvailable());
        Assert.assertEquals((long)6000L, (long)feature2.availability());
        Object feature3 = provider.getFeature("feature_3");
        Assert.assertFalse((boolean)feature3.isAvailable());
        Assert.assertEquals((long)0L, (long)feature3.availability());
        Object feature4 = provider.getFeature("feature_4");
        Assert.assertTrue((boolean)feature4.isAvailable());
        Assert.assertEquals((long)6000L, (long)feature4.availability());
        Object feature5 = provider.getFeature("unknown_feature");
        Assert.assertFalse((boolean)feature5.isAvailable());
        Assert.assertEquals((long)0L, (long)feature5.availability());
        provider.stop();
    }

    @Test(timeout=60000L)
    public void testReloadFeaturesFromOverlay() throws Exception {
        PropertiesWriter writer = new PropertiesWriter();
        writer.setProperty("feature_1", "10000");
        writer.setProperty("feature_2", "5000");
        writer.save();
        PropertiesWriter overlayWriter = new PropertiesWriter();
        overlayWriter.setProperty("feature_2", "6000");
        overlayWriter.setProperty("feature_4", "6000");
        overlayWriter.save();
        DistributedLogConfiguration conf = new DistributedLogConfiguration().setDynamicConfigReloadIntervalSec(Integer.MAX_VALUE).setFileFeatureProviderBaseConfigPath(writer.getFile().toURI().toURL().getPath()).setFileFeatureProviderOverlayConfigPath(overlayWriter.getFile().toURI().toURL().getPath());
        DynamicConfigurationFeatureProvider provider = new DynamicConfigurationFeatureProvider("", conf, NullStatsLogger.INSTANCE);
        provider.start();
        this.ensureConfigReloaded();
        Object feature1 = provider.getFeature("feature_1");
        Assert.assertTrue((boolean)feature1.isAvailable());
        Assert.assertEquals((long)10000L, (long)feature1.availability());
        Object feature2 = provider.getFeature("feature_2");
        Assert.assertTrue((boolean)feature2.isAvailable());
        Assert.assertEquals((long)6000L, (long)feature2.availability());
        Object feature3 = provider.getFeature("feature_3");
        Assert.assertFalse((boolean)feature3.isAvailable());
        Assert.assertEquals((long)0L, (long)feature3.availability());
        Object feature4 = provider.getFeature("feature_4");
        Assert.assertTrue((boolean)feature4.isAvailable());
        Assert.assertEquals((long)6000L, (long)feature4.availability());
        Object feature5 = provider.getFeature("unknown_feature");
        Assert.assertFalse((boolean)feature5.isAvailable());
        Assert.assertEquals((long)0L, (long)feature5.availability());
        provider.getFeatureConf().setProperty("feature_1", 3000);
        provider.getFeatureConf().setProperty("feature_2", 7000);
        provider.getFeatureConf().setProperty("feature_3", 8000);
        provider.getFeatureConf().setProperty("feature_4", 9000);
        provider.onReload(provider.getFeatureConf());
        feature1 = provider.getFeature("feature_1");
        Assert.assertTrue((boolean)feature1.isAvailable());
        Assert.assertEquals((long)3000L, (long)feature1.availability());
        feature2 = provider.getFeature("feature_2");
        Assert.assertTrue((boolean)feature2.isAvailable());
        Assert.assertEquals((long)7000L, (long)feature2.availability());
        feature3 = provider.getFeature("feature_3");
        Assert.assertTrue((boolean)feature3.isAvailable());
        Assert.assertEquals((long)8000L, (long)feature3.availability());
        feature4 = provider.getFeature("feature_4");
        Assert.assertTrue((boolean)feature4.isAvailable());
        Assert.assertEquals((long)9000L, (long)feature4.availability());
        provider.stop();
    }
}

