/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.metadata;

import java.io.IOException;
import java.net.URI;
import org.apache.distributedlog.LocalDLMEmulator;
import org.apache.distributedlog.ZooKeeperClusterTestCase;
import org.apache.distributedlog.impl.metadata.BKDLConfig;
import org.apache.distributedlog.metadata.DLMetadata;
import org.apache.pulsar.shade.org.apache.zookeeper.ZooKeeper;
import org.apache.pulsar.shade.org.apache.zookeeper.data.Stat;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDLMetadata
extends ZooKeeperClusterTestCase {
    private static final BKDLConfig bkdlConfig = new BKDLConfig("127.0.0.1:7000", "127.0.0.1:7000", "127.0.0.1:7000", "127.0.0.1:7000", "ledgers");
    private static final BKDLConfig bkdlConfig2 = new BKDLConfig("127.0.0.1:7001", "127.0.0.1:7002", "127.0.0.1:7003", "127.0.0.1:7004", "ledgers2");
    private ZooKeeper zkc;

    @Before
    public void setup() throws Exception {
        this.zkc = LocalDLMEmulator.connectZooKeeper("127.0.0.1", zkPort);
    }

    @After
    public void teardown() throws Exception {
        this.zkc.close();
    }

    private URI createURI(String path) {
        return URI.create("distributedlog://127.0.0.1:" + zkPort + path);
    }

    @Test(timeout=60000L)
    public void testBadMetadata() throws Exception {
        URI uri = this.createURI("/");
        try {
            DLMetadata.deserialize(uri, new byte[0]);
            Assert.fail((String)"Should fail to deserialize invalid metadata");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            DLMetadata.deserialize(uri, new DLMetadata("unknown", bkdlConfig).serialize());
            Assert.fail((String)"Should fail to deserialize due to unknown dl type.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            DLMetadata.deserialize(uri, new DLMetadata("BKDL", bkdlConfig, 9999).serialize());
            Assert.fail((String)"Should fail to deserialize due to invalid version.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byte[] data = new DLMetadata("BKDL", bkdlConfig).serialize();
        byte[] badData = new byte[data.length - 3];
        System.arraycopy(data, 0, badData, 0, badData.length);
        try {
            DLMetadata.deserialize(uri, badData);
            Assert.fail((String)"Should fail to deserialize truncated data.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test(timeout=60000L)
    public void testGoodMetadata() throws Exception {
        URI uri = this.createURI("/");
        byte[] data = new DLMetadata("BKDL", bkdlConfig).serialize();
        DLMetadata deserailized = DLMetadata.deserialize(uri, data);
        Assert.assertEquals((Object)bkdlConfig, (Object)deserailized.getDLConfig());
    }

    @Test(timeout=60000L)
    public void testWriteMetadata() throws Exception {
        DLMetadata metadata = new DLMetadata("BKDL", bkdlConfig);
        try {
            metadata.create(this.createURI("//metadata"));
            Assert.fail((String)"Should fail due to invalid uri.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        URI uri = this.createURI("/metadata");
        metadata.create(uri);
        try {
            metadata.create(uri);
            Assert.fail((String)"Should fail when create on existed path");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            metadata.update(this.createURI("/unexisted"));
            Assert.fail((String)"Should fail when update on unexisted path");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byte[] data = this.zkc.getData("/metadata", false, new Stat());
        Assert.assertEquals((Object)bkdlConfig, (Object)DLMetadata.deserialize(uri, data).getDLConfig());
        DLMetadata newMetadata = new DLMetadata("BKDL", bkdlConfig2);
        newMetadata.update(this.createURI("/metadata"));
        byte[] newData = this.zkc.getData("/metadata", false, new Stat());
        Assert.assertEquals((Object)bkdlConfig2, (Object)DLMetadata.deserialize(uri, newData).getDLConfig());
    }

    @Test(timeout=60000L)
    public void testMetadataWithoutDLZKServers() throws Exception {
        this.testMetadataWithOrWithoutZkServers("/metadata-without-dlzk-servers", null, null, "127.0.0.1:7003", "127.0.0.1:7004", "127.0.0.1:" + zkPort, "127.0.0.1:" + zkPort, "127.0.0.1:7003", "127.0.0.1:7004");
    }

    @Test(timeout=60000L)
    public void testMetadataWithoutDLZKServersForRead() throws Exception {
        this.testMetadataWithOrWithoutZkServers("/metadata-without-dlzk-servers-for-read", "127.0.0.1:7001", null, "127.0.0.1:7003", "127.0.0.1:7004", "127.0.0.1:7001", "127.0.0.1:7001", "127.0.0.1:7003", "127.0.0.1:7004");
    }

    @Test(timeout=60000L)
    public void testMetadataWithoutBKZKServersForRead() throws Exception {
        this.testMetadataWithOrWithoutZkServers("/metadata-without-bkzk-servers-for-read", "127.0.0.1:7001", null, "127.0.0.1:7003", null, "127.0.0.1:7001", "127.0.0.1:7001", "127.0.0.1:7003", "127.0.0.1:7003");
    }

    private void testMetadataWithOrWithoutZkServers(String metadataPath, String dlZkServersForWriter, String dlZkServersForReader, String bkZkServersForWriter, String bkZkServersForReader, String expectedDlZkServersForWriter, String expectedDlZkServersForReader, String expectedBkZkServersForWriter, String expectedBkZkServersForReader) throws Exception {
        BKDLConfig bkdlConfig = new BKDLConfig(dlZkServersForWriter, dlZkServersForReader, bkZkServersForWriter, bkZkServersForReader, "ledgers");
        BKDLConfig expectedBKDLConfig = new BKDLConfig(expectedDlZkServersForWriter, expectedDlZkServersForReader, expectedBkZkServersForWriter, expectedBkZkServersForReader, "ledgers");
        URI uri = this.createURI(metadataPath);
        DLMetadata metadata = new DLMetadata("BKDL", bkdlConfig);
        metadata.create(uri);
        byte[] data = this.zkc.getData(metadataPath, false, new Stat());
        Assert.assertEquals((Object)expectedBKDLConfig, (Object)DLMetadata.deserialize(uri, data).getDLConfig());
    }

    @Test(timeout=60000L)
    public void testMetadataMissingRequiredFields() throws Exception {
        BKDLConfig bkdlConfig = new BKDLConfig(null, null, null, null, "ledgers");
        URI uri = this.createURI("/metadata-missing-fields");
        DLMetadata metadata = new DLMetadata("BKDL", bkdlConfig);
        metadata.create(uri);
        byte[] data = this.zkc.getData("/metadata-missing-fields", false, new Stat());
        try {
            DLMetadata.deserialize(uri, data);
            Assert.fail((String)"Should fail on deserializing metadata missing fields");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

