/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.util;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.distributedlog.DLMTestUtil;
import org.apache.distributedlog.LogSegmentMetadata;
import org.apache.distributedlog.exceptions.InvalidStreamNameException;
import org.apache.distributedlog.exceptions.UnexpectedException;
import org.apache.distributedlog.util.DLUtils;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;

public class TestDLUtils {
    private static LogSegmentMetadata completedLogSegment(long logSegmentSequenceNumber, long fromTxnId, long toTxnId) {
        return TestDLUtils.completedLogSegment(logSegmentSequenceNumber, fromTxnId, toTxnId, LogSegmentMetadata.LEDGER_METADATA_CURRENT_LAYOUT_VERSION);
    }

    private static LogSegmentMetadata completedLogSegment(long logSegmentSequenceNumber, long fromTxnId, long toTxnId, int version) {
        return DLMTestUtil.completedLogSegment("/logsegment/" + fromTxnId, fromTxnId, fromTxnId, toTxnId, 100, logSegmentSequenceNumber, 999L, 0L, version);
    }

    private static LogSegmentMetadata inprogressLogSegment(long logSegmentSequenceNumber, long firstTxId) {
        return TestDLUtils.inprogressLogSegment(logSegmentSequenceNumber, firstTxId, LogSegmentMetadata.LEDGER_METADATA_CURRENT_LAYOUT_VERSION);
    }

    private static LogSegmentMetadata inprogressLogSegment(long logSegmentSequenceNumber, long firstTxId, int version) {
        return DLMTestUtil.inprogressLogSegment("/logsegment/" + firstTxId, firstTxId, firstTxId, logSegmentSequenceNumber, version);
    }

    @Test(timeout=60000L)
    public void testFindLogSegmentNotLessThanTxnId() throws Exception {
        long txnId = 999L;
        ArrayList<LogSegmentMetadata> emptyList = Lists.newArrayList();
        Assert.assertEquals((long)-1L, (long)DLUtils.findLogSegmentNotLessThanTxnId(emptyList, txnId));
        ArrayList<LogSegmentMetadata> list1 = Lists.newArrayList(TestDLUtils.completedLogSegment(1L, 1000L, 2000L));
        Assert.assertEquals((long)-1L, (long)DLUtils.findLogSegmentNotLessThanTxnId(list1, txnId));
        ArrayList<LogSegmentMetadata> list2 = Lists.newArrayList(TestDLUtils.inprogressLogSegment(1L, 1000L));
        Assert.assertEquals((long)-1L, (long)DLUtils.findLogSegmentNotLessThanTxnId(list2, txnId));
        ArrayList<LogSegmentMetadata> list3 = Lists.newArrayList(TestDLUtils.completedLogSegment(1L, 0L, 99L), TestDLUtils.completedLogSegment(2L, 1000L, 2000L));
        Assert.assertEquals((long)1L, (long)DLUtils.findLogSegmentNotLessThanTxnId(list3, txnId));
        ArrayList<LogSegmentMetadata> list4 = Lists.newArrayList(TestDLUtils.completedLogSegment(1L, 0L, 990L), TestDLUtils.completedLogSegment(2L, 1000L, 2000L));
        Assert.assertEquals((long)1L, (long)DLUtils.findLogSegmentNotLessThanTxnId(list4, txnId));
        ArrayList<LogSegmentMetadata> list5 = Lists.newArrayList(TestDLUtils.inprogressLogSegment(1L, 0L), TestDLUtils.inprogressLogSegment(2L, 1000L));
        Assert.assertEquals((long)0L, (long)DLUtils.findLogSegmentNotLessThanTxnId(list5, txnId));
        ArrayList<LogSegmentMetadata> list6_0 = Lists.newArrayList(TestDLUtils.completedLogSegment(1L, 100L, 200L));
        Assert.assertEquals((long)0L, (long)DLUtils.findLogSegmentNotLessThanTxnId(list6_0, txnId));
        ArrayList<LogSegmentMetadata> list6_1 = Lists.newArrayList(TestDLUtils.completedLogSegment(1L, 100L, 199L), TestDLUtils.completedLogSegment(2L, 200L, 299L));
        Assert.assertEquals((long)1L, (long)DLUtils.findLogSegmentNotLessThanTxnId(list6_1, txnId));
        ArrayList<LogSegmentMetadata> list7 = Lists.newArrayList(TestDLUtils.inprogressLogSegment(1L, 100L));
        Assert.assertEquals((long)0L, (long)DLUtils.findLogSegmentNotLessThanTxnId(list7, txnId));
        ArrayList<LogSegmentMetadata> list8 = Lists.newArrayList(TestDLUtils.completedLogSegment(1L, 999L, 2000L));
        Assert.assertEquals((long)0L, (long)DLUtils.findLogSegmentNotLessThanTxnId(list8, txnId));
        ArrayList<LogSegmentMetadata> list9 = Lists.newArrayList(TestDLUtils.inprogressLogSegment(1L, 999L));
        Assert.assertEquals((long)0L, (long)DLUtils.findLogSegmentNotLessThanTxnId(list9, txnId));
        ArrayList<LogSegmentMetadata> list10 = Lists.newArrayList(TestDLUtils.completedLogSegment(1L, 0L, 999L), TestDLUtils.completedLogSegment(2L, 999L, 2000L));
        Assert.assertEquals((long)0L, (long)DLUtils.findLogSegmentNotLessThanTxnId(list10, txnId));
        ArrayList<LogSegmentMetadata> list11 = Lists.newArrayList(TestDLUtils.completedLogSegment(1L, 0L, 99L), TestDLUtils.completedLogSegment(2L, 999L, 2000L));
        Assert.assertEquals((long)1L, (long)DLUtils.findLogSegmentNotLessThanTxnId(list11, txnId));
        ArrayList<LogSegmentMetadata> list12 = Lists.newArrayList(TestDLUtils.inprogressLogSegment(1L, 0L), TestDLUtils.inprogressLogSegment(2L, 999L));
        Assert.assertEquals((long)1L, (long)DLUtils.findLogSegmentNotLessThanTxnId(list12, txnId));
    }

    @Test(timeout=60000L)
    public void testNextLogSegmentSequenceNumber() throws Exception {
        ArrayList<LogSegmentMetadata> v1List = Lists.newArrayList(TestDLUtils.completedLogSegment(2L, 100L, 199L, LogSegmentMetadata.LogSegmentMetadataVersion.VERSION_V1_ORIGINAL.value), TestDLUtils.completedLogSegment(1L, 0L, 99L, LogSegmentMetadata.LogSegmentMetadataVersion.VERSION_V1_ORIGINAL.value));
        Assert.assertNull((Object)DLUtils.nextLogSegmentSequenceNumber(v1List));
        ArrayList<LogSegmentMetadata> afterV1List = Lists.newArrayList(TestDLUtils.completedLogSegment(2L, 100L, 199L), TestDLUtils.completedLogSegment(1L, 0L, 99L));
        Assert.assertEquals((Object)3L, (Object)DLUtils.nextLogSegmentSequenceNumber(afterV1List));
        ArrayList<LogSegmentMetadata> mixList1 = Lists.newArrayList(TestDLUtils.completedLogSegment(2L, 100L, 199L, LogSegmentMetadata.LogSegmentMetadataVersion.VERSION_V1_ORIGINAL.value), TestDLUtils.completedLogSegment(1L, 0L, 99L));
        Assert.assertEquals((Object)3L, (Object)DLUtils.nextLogSegmentSequenceNumber(mixList1));
        ArrayList<LogSegmentMetadata> mixList2 = Lists.newArrayList(TestDLUtils.completedLogSegment(2L, 100L, 199L), TestDLUtils.completedLogSegment(1L, 0L, 99L, LogSegmentMetadata.LogSegmentMetadataVersion.VERSION_V1_ORIGINAL.value));
        Assert.assertEquals((Object)3L, (Object)DLUtils.nextLogSegmentSequenceNumber(mixList2));
    }

    @Test(timeout=60000L, expected=UnexpectedException.class)
    public void testUnexpectedExceptionOnComputeStartSequenceId() throws Exception {
        ArrayList<LogSegmentMetadata> segments = Lists.newArrayList(TestDLUtils.inprogressLogSegment(3L, 201L), TestDLUtils.inprogressLogSegment(2L, 101L), TestDLUtils.completedLogSegment(1L, 1L, 100L).mutator().setStartSequenceId(1L).build());
        DLUtils.computeStartSequenceId(segments, (LogSegmentMetadata)segments.get(0));
    }

    @Test(timeout=60000L)
    public void testComputeStartSequenceIdOnEmptyList() throws Exception {
        ArrayList<LogSegmentMetadata> emptyList = Lists.newArrayList();
        Assert.assertEquals((long)0L, (long)DLUtils.computeStartSequenceId(emptyList, TestDLUtils.inprogressLogSegment(1L, 1L)));
    }

    @Test(timeout=60000L)
    public void testComputeStartSequenceIdOnLowerSequenceNumberSegment() throws Exception {
        ArrayList<LogSegmentMetadata> segments = Lists.newArrayList(TestDLUtils.completedLogSegment(3L, 201L, 300L).mutator().setStartSequenceId(201L).build(), TestDLUtils.completedLogSegment(2L, 101L, 200L).mutator().setStartSequenceId(101L).build());
        Assert.assertEquals((long)0L, (long)DLUtils.computeStartSequenceId(segments, TestDLUtils.inprogressLogSegment(1L, 1L)));
    }

    @Test(timeout=60000L)
    public void testComputeStartSequenceIdOnHigherSequenceNumberSegment() throws Exception {
        ArrayList<LogSegmentMetadata> segments = Lists.newArrayList(TestDLUtils.completedLogSegment(3L, 201L, 300L).mutator().setStartSequenceId(201L).build(), TestDLUtils.completedLogSegment(2L, 101L, 200L).mutator().setStartSequenceId(101L).build());
        Assert.assertEquals((long)0L, (long)DLUtils.computeStartSequenceId(segments, TestDLUtils.inprogressLogSegment(5L, 401L)));
    }

    @Test(timeout=60000L)
    public void testComputeStartSequenceId() throws Exception {
        ArrayList<LogSegmentMetadata> segments = Lists.newArrayList(TestDLUtils.completedLogSegment(3L, 201L, 300L).mutator().setStartSequenceId(201L).setRecordCount(100).build(), TestDLUtils.completedLogSegment(2L, 101L, 200L).mutator().setStartSequenceId(101L).setRecordCount(100).build());
        Assert.assertEquals((long)301L, (long)DLUtils.computeStartSequenceId(segments, TestDLUtils.inprogressLogSegment(4L, 301L)));
    }

    @Test(timeout=60000L)
    public void testSerDeLogSegmentSequenceNumber() throws Exception {
        long sn = 123456L;
        byte[] snData = Long.toString(sn).getBytes(StandardCharsets.UTF_8);
        Assert.assertEquals((String)"Deserialization should succeed", (long)sn, (long)DLUtils.deserializeLogSegmentSequenceNumber(snData));
        Assert.assertArrayEquals((String)"Serialization should succeed", (byte[])snData, (byte[])DLUtils.serializeLogSegmentSequenceNumber(sn));
    }

    @Test(timeout=60000L, expected=NumberFormatException.class)
    public void testDeserilizeInvalidLSSN() throws Exception {
        byte[] corruptedData = "corrupted-lssn".getBytes(StandardCharsets.UTF_8);
        DLUtils.deserializeLogSegmentSequenceNumber(corruptedData);
    }

    @Test(timeout=60000L)
    public void testSerDeLogRecordTxnId() throws Exception {
        long txnId = 123456L;
        byte[] txnData = Long.toString(txnId).getBytes(StandardCharsets.UTF_8);
        Assert.assertEquals((String)"Deserialization should succeed", (long)txnId, (long)DLUtils.deserializeTransactionId(txnData));
        Assert.assertArrayEquals((String)"Serialization should succeed", (byte[])txnData, (byte[])DLUtils.serializeTransactionId(txnId));
    }

    @Test(timeout=60000L, expected=NumberFormatException.class)
    public void testDeserilizeInvalidLogRecordTxnId() throws Exception {
        byte[] corruptedData = "corrupted-txn-id".getBytes(StandardCharsets.UTF_8);
        DLUtils.deserializeTransactionId(corruptedData);
    }

    @Test(timeout=60000L)
    public void testSerDeLedgerId() throws Exception {
        long ledgerId = 123456L;
        byte[] ledgerIdData = Long.toString(ledgerId).getBytes(StandardCharsets.UTF_8);
        Assert.assertEquals((String)"Deserialization should succeed", (long)ledgerId, (long)DLUtils.bytes2LogSegmentId(ledgerIdData));
        Assert.assertArrayEquals((String)"Serialization should succeed", (byte[])ledgerIdData, (byte[])DLUtils.logSegmentId2Bytes(ledgerId));
    }

    @Test(timeout=60000L, expected=NumberFormatException.class)
    public void testDeserializeInvalidLedgerId() throws Exception {
        byte[] corruptedData = "corrupted-ledger-id".getBytes(StandardCharsets.UTF_8);
        DLUtils.bytes2LogSegmentId(corruptedData);
    }

    @Test(timeout=10000L)
    public void testValidateLogName() throws Exception {
        String logName = "test-validate-log-name";
        DLUtils.validateAndNormalizeName(logName);
    }

    @Test(timeout=10000L, expected=InvalidStreamNameException.class)
    public void testValidateBadLogName0() throws Exception {
        String logName = "  test-bad-log-name";
        DLUtils.validateAndNormalizeName(logName);
    }

    @Test(timeout=10000L, expected=InvalidStreamNameException.class)
    public void testValidateBadLogName1() throws Exception {
        String logName = "test-bad-log-name/";
        DLUtils.validateAndNormalizeName(logName);
    }

    @Test(timeout=10000L, expected=InvalidStreamNameException.class)
    public void testValidateBadLogName2() throws Exception {
        String logName = "../test-bad-log-name/";
        DLUtils.validateAndNormalizeName(logName);
    }

    @Test(timeout=10000L)
    public void testValidateSameStreamPath() throws Exception {
        String logName1 = "/test-resolve-log";
        String logName2 = "test-resolve-log";
        DLUtils.validateAndNormalizeName(logName1);
        DLUtils.validateAndNormalizeName(logName2);
    }
}

