/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.zk;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.distributedlog.util.Transaction;
import org.apache.distributedlog.zk.ZKVersionedSetOp;
import org.apache.pulsar.shade.org.apache.bookkeeper.versioning.Version;
import org.apache.pulsar.shade.org.apache.zookeeper.KeeperException;
import org.apache.pulsar.shade.org.apache.zookeeper.Op;
import org.apache.pulsar.shade.org.apache.zookeeper.OpResult;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestZKVersionedSetOp {
    @Test(timeout=60000L)
    public void testAbortNullOpResult() throws Exception {
        final AtomicReference exception = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        ZKVersionedSetOp versionedSetOp = new ZKVersionedSetOp((Op)Mockito.mock(Op.class), new Transaction.OpListener<Version>(){

            @Override
            public void onCommit(Version r) {
            }

            @Override
            public void onAbort(Throwable t) {
                exception.set(t);
                latch.countDown();
            }
        });
        KeeperException ke = KeeperException.create(KeeperException.Code.SESSIONEXPIRED);
        versionedSetOp.abortOpResult(ke, null);
        latch.await();
        Assert.assertTrue((ke == exception.get() ? 1 : 0) != 0);
    }

    @Test(timeout=60000L)
    public void testAbortOpResult() throws Exception {
        final AtomicReference exception = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        ZKVersionedSetOp versionedSetOp = new ZKVersionedSetOp((Op)Mockito.mock(Op.class), new Transaction.OpListener<Version>(){

            @Override
            public void onCommit(Version r) {
            }

            @Override
            public void onAbort(Throwable t) {
                exception.set(t);
                latch.countDown();
            }
        });
        KeeperException ke = KeeperException.create(KeeperException.Code.SESSIONEXPIRED);
        OpResult.ErrorResult opResult = new OpResult.ErrorResult(KeeperException.Code.NONODE.intValue());
        versionedSetOp.abortOpResult(ke, opResult);
        latch.await();
        Assert.assertTrue((boolean)(exception.get() instanceof KeeperException.NoNodeException));
    }
}

