/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.bookie;

import java.io.IOException;
import java.util.function.Supplier;
import org.apache.pulsar.shade.io.netty.buffer.ByteBufAllocator;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.Bookie;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.BookieException;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.BookieStateManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.StateManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.discover.BookieServiceInfo;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.StatsLogger;
import org.apache.pulsar.shade.org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlyBookie
extends Bookie {
    private static final Logger LOG = LoggerFactory.getLogger(ReadOnlyBookie.class);

    public ReadOnlyBookie(ServerConfiguration conf, StatsLogger statsLogger, ByteBufAllocator allocator, Supplier<BookieServiceInfo> bookieServiceInfoProvider) throws IOException, KeeperException, InterruptedException, BookieException {
        super(conf, statsLogger, allocator, bookieServiceInfoProvider);
        if (!conf.isReadOnlyModeEnabled()) {
            String err = "Try to init ReadOnly Bookie, while ReadOnly mode is not enabled";
            LOG.error(err);
            throw new IOException(err);
        }
        this.stateManager.forceToReadOnly();
        LOG.info("Running bookie in force readonly mode.");
    }

    @Override
    StateManager initializeStateManager() throws IOException {
        return new BookieStateManager(this.conf, this.statsLogger, this.metadataDriver, this.getLedgerDirsManager(), this.bookieServiceInfoProvider){

            @Override
            public void doTransitionToWritableMode() {
                LOG.info("Skip transition to writable mode for readonly bookie");
            }

            @Override
            public void doTransitionToReadOnlyMode() {
                LOG.info("Skip transition to readonly mode for readonly bookie");
            }
        };
    }
}

