/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.clients.config;

import java.util.Optional;
import org.apache.pulsar.shade.org.apache.bookkeeper.clients.config.StorageClientSettings_Builder;
import org.apache.pulsar.shade.org.apache.bookkeeper.clients.resolver.EndpointResolver;
import org.apache.pulsar.shade.org.apache.bookkeeper.clients.utils.ClientConstants;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.net.ServiceURI;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.Backoff;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.StatsLogger;

public interface StorageClientSettings {
    public int numWorkerThreads();

    public String serviceUri();

    public EndpointResolver endpointResolver();

    public boolean usePlaintext();

    public Optional<String> clientName();

    public Optional<StatsLogger> statsLogger();

    public Backoff.Policy backoffPolicy();

    public boolean enableServerSideRouting();

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends StorageClientSettings_Builder {
        Builder() {
            this.numWorkerThreads(Runtime.getRuntime().availableProcessors());
            this.usePlaintext(true);
            this.backoffPolicy(ClientConstants.DEFAULT_INFINIT_BACKOFF_POLICY);
            this.endpointResolver(EndpointResolver.identity());
            this.enableServerSideRouting(false);
        }

        @Override
        public StorageClientSettings build() {
            StorageClientSettings settings = super.build();
            ServiceURI.create(this.serviceUri());
            return settings;
        }
    }
}

