/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.proto.checksum;

import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.ByteBufAllocator;
import org.apache.pulsar.shade.io.netty.util.concurrent.FastThreadLocal;
import org.apache.pulsar.shade.org.apache.bookkeeper.proto.checksum.DigestManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.proto.checksum.DirectMemoryCRC32Digest;
import org.apache.pulsar.shade.org.apache.bookkeeper.proto.checksum.StandardCRC32Digest;

class CRC32DigestManager
extends DigestManager {
    private static final FastThreadLocal<CRC32Digest> crc = new FastThreadLocal<CRC32Digest>(){

        @Override
        protected CRC32Digest initialValue() {
            if (DirectMemoryCRC32Digest.isSupported()) {
                return new DirectMemoryCRC32Digest();
            }
            return new StandardCRC32Digest();
        }
    };

    public CRC32DigestManager(long ledgerId, boolean useV2Protocol, ByteBufAllocator allocator) {
        super(ledgerId, useV2Protocol, allocator);
    }

    @Override
    int getMacCodeLength() {
        return 8;
    }

    @Override
    void populateValueAndReset(ByteBuf buf) {
        buf.writeLong(crc.get().getValueAndReset());
    }

    @Override
    void update(ByteBuf data) {
        crc.get().update(data);
    }

    static interface CRC32Digest {
        public long getValueAndReset();

        public void update(ByteBuf var1);
    }
}

