/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.statelib.impl.mvcc.op.proto;

import java.util.Arrays;
import org.apache.pulsar.shade.com.google.protobuf.ByteString;
import org.apache.pulsar.shade.io.netty.util.Recycler;
import org.apache.pulsar.shade.org.apache.bookkeeper.api.kv.op.CompareOp;
import org.apache.pulsar.shade.org.apache.bookkeeper.api.kv.op.CompareResult;
import org.apache.pulsar.shade.org.apache.bookkeeper.api.kv.op.CompareTarget;
import org.apache.pulsar.shade.org.apache.bookkeeper.statelib.impl.mvcc.MVCCUtils;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.kv.rpc.Compare;

public class ProtoCompareImpl
implements CompareOp<byte[], byte[]> {
    private static final Recycler<ProtoCompareImpl> RECYCLER = new Recycler<ProtoCompareImpl>(){

        @Override
        protected ProtoCompareImpl newObject(Recycler.Handle<ProtoCompareImpl> handle) {
            return new ProtoCompareImpl(handle);
        }
    };
    private final Recycler.Handle<ProtoCompareImpl> recyclerHandle;
    private Compare request;
    private CompareTarget target;
    private CompareResult result;
    private byte[] key;
    private byte[] value;

    public static ProtoCompareImpl newCompareOp(Compare protoCompare) {
        ProtoCompareImpl op = RECYCLER.get();
        op.setRequest(protoCompare);
        op.setTarget(MVCCUtils.toApiCompareTarget(protoCompare.getTarget()));
        op.setResult(MVCCUtils.toApiCompareResult(protoCompare.getResult()));
        return op;
    }

    private void reset() {
        this.request = null;
        this.key = null;
        this.value = null;
        this.target = null;
        this.result = null;
    }

    @Override
    public CompareTarget target() {
        return this.target;
    }

    @Override
    public CompareResult result() {
        return this.result;
    }

    @Override
    public byte[] key() {
        if (null != this.key) {
            return this.key;
        }
        this.key = (byte[])(ByteString.EMPTY == this.request.getKey() ? null : this.request.getKey().toByteArray());
        return this.key;
    }

    @Override
    public byte[] value() {
        if (null != this.value) {
            return this.value;
        }
        this.value = (byte[])(ByteString.EMPTY == this.request.getValue() ? null : this.request.getValue().toByteArray());
        return this.value;
    }

    @Override
    public long revision() {
        Compare req = this.request;
        if (null == req) {
            return -1L;
        }
        switch (req.getTarget()) {
            case MOD: {
                return req.getModRevision();
            }
            case CREATE: {
                return req.getCreateRevision();
            }
            case VERSION: {
                return req.getVersion();
            }
        }
        return -1L;
    }

    @Override
    public void close() {
        this.reset();
        this.recyclerHandle.recycle(this);
    }

    public ProtoCompareImpl(Recycler.Handle<ProtoCompareImpl> recyclerHandle) {
        this.recyclerHandle = recyclerHandle;
    }

    private void setRequest(Compare request) {
        this.request = request;
    }

    private void setTarget(CompareTarget target) {
        this.target = target;
    }

    private void setResult(CompareResult result) {
        this.result = result;
    }

    private void setKey(byte[] key) {
        this.key = key;
    }

    private void setValue(byte[] value) {
        this.value = value;
    }

    public String toString() {
        return "ProtoCompareImpl(request=" + this.request + ", target=" + (Object)((Object)this.target) + ", result=" + (Object)((Object)this.result) + ", key=" + Arrays.toString(this.key) + ", value=" + Arrays.toString(this.value) + ")";
    }
}

