/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.util;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.ClassLoaderUtils;

public class Reflections {
    private static final Map<Class<?>, Constructor<?>> constructorCache = new ConcurrentHashMap();
    private static final Map PRIMITIVE_NAME_TYPE_MAP = new HashMap();

    public static <T> T createInstance(String userClassName, Class<T> xface, ClassLoader classLoader) {
        Object result;
        Class<?> theCls;
        try {
            theCls = Class.forName(userClassName, true, classLoader);
        }
        catch (ClassNotFoundException | NoClassDefFoundError cnfe) {
            throw new RuntimeException("User class must be in class path", cnfe);
        }
        if (!xface.isAssignableFrom(theCls)) {
            throw new RuntimeException(userClassName + " does not implement " + xface.getName());
        }
        Class<T> tCls = theCls.asSubclass(xface);
        try {
            Constructor<Object> meth = constructorCache.get(theCls);
            if (null == meth) {
                meth = tCls.getDeclaredConstructor(new Class[0]);
                meth.setAccessible(true);
                constructorCache.put(theCls, meth);
            }
            result = meth.newInstance(new Object[0]);
        }
        catch (InstantiationException ie) {
            throw new RuntimeException("User class must be concrete", ie);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("User class must have a no-arg constructor", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("User class must have a public constructor", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("User class constructor throws exception", e);
        }
        return (T)result;
    }

    public static Object createInstance(String userClassName, ClassLoader classLoader) {
        Object result;
        Class<?> theCls;
        try {
            theCls = Class.forName(userClassName, true, classLoader);
        }
        catch (ClassNotFoundException | NoClassDefFoundError cnfe) {
            throw new RuntimeException("User class must be in class path", cnfe);
        }
        try {
            Constructor<?> meth = constructorCache.get(theCls);
            if (null == meth) {
                meth = theCls.getDeclaredConstructor(new Class[0]);
                meth.setAccessible(true);
                constructorCache.put(theCls, meth);
            }
            result = meth.newInstance(new Object[0]);
        }
        catch (InstantiationException ie) {
            throw new RuntimeException("User class must be concrete", ie);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("User class doesn't have such method", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("User class must have a no-arg constructor", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("User class constructor throws exception", e);
        }
        return result;
    }

    public static Object createInstance(String userClassName, ClassLoader classLoader, Object[] params, Class[] paramTypes) {
        Object result;
        Class<?> theCls;
        if (params.length != paramTypes.length) {
            throw new RuntimeException("Unequal number of params and paramTypes. Each param must have a corresponding param type");
        }
        try {
            theCls = Class.forName(userClassName, true, classLoader);
        }
        catch (ClassNotFoundException | NoClassDefFoundError cnfe) {
            throw new RuntimeException("User class must be in class path", cnfe);
        }
        try {
            Constructor<?> meth = constructorCache.get(theCls);
            if (null == meth) {
                meth = theCls.getDeclaredConstructor(paramTypes);
                meth.setAccessible(true);
                constructorCache.put(theCls, meth);
            }
            result = meth.newInstance(params);
        }
        catch (InstantiationException ie) {
            throw new RuntimeException("User class must be concrete", ie);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("User class doesn't have such method", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("User class must have a no-arg constructor", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("User class constructor throws exception", e);
        }
        return result;
    }

    public static Object createInstance(String userClassName, File jar) {
        try {
            return Reflections.createInstance(userClassName, ClassLoaderUtils.loadJar(jar));
        }
        catch (Exception ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean classExistsInJar(File jar, String fqcn) {
        URLClassLoader loader = null;
        try {
            loader = (URLClassLoader)ClassLoaderUtils.loadJar(jar);
            Class.forName(fqcn, false, loader);
            boolean bl = true;
            return bl;
        }
        catch (IOException | ClassNotFoundException | NoClassDefFoundError e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (loader != null) {
                try {
                    loader.close();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
    }

    public static boolean classExists(String fqcn) {
        try {
            Class.forName(fqcn);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean classInJarImplementsIface(File jar, String fqcn, Class xface) {
        boolean ret = false;
        URLClassLoader loader = null;
        try {
            loader = (URLClassLoader)ClassLoaderUtils.loadJar(jar);
            if (xface.isAssignableFrom(Class.forName(fqcn, false, loader))) {
                ret = true;
            }
        }
        catch (IOException | ClassNotFoundException | NoClassDefFoundError e) {
            throw new RuntimeException(e);
        }
        finally {
            if (loader != null) {
                try {
                    loader.close();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
        return ret;
    }

    public static boolean classImplementsIface(String fqcn, Class xface) {
        boolean ret = false;
        try {
            if (xface.isAssignableFrom(Class.forName(fqcn))) {
                ret = true;
            }
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    private static boolean isPrimitive(String type) {
        return PRIMITIVE_NAME_TYPE_MAP.containsKey(type);
    }

    public static Class loadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        if (className.length() == 1) {
            char type = className.charAt(0);
            if (type == 'B') {
                return Byte.TYPE;
            }
            if (type == 'C') {
                return Character.TYPE;
            }
            if (type == 'D') {
                return Double.TYPE;
            }
            if (type == 'F') {
                return Float.TYPE;
            }
            if (type == 'I') {
                return Integer.TYPE;
            }
            if (type == 'J') {
                return Long.TYPE;
            }
            if (type == 'S') {
                return Short.TYPE;
            }
            if (type == 'Z') {
                return Boolean.TYPE;
            }
            if (type == 'V') {
                return Void.TYPE;
            }
            throw new ClassNotFoundException(className);
        }
        if (Reflections.isPrimitive(className)) {
            return (Class)PRIMITIVE_NAME_TYPE_MAP.get(className);
        }
        if (className.charAt(0) == 'L' && className.charAt(className.length() - 1) == ';') {
            return classLoader.loadClass(className.substring(1, className.length() - 1));
        }
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException | NoClassDefFoundError var4) {
            if (className.charAt(0) != '[') {
                throw var4;
            }
            int arrayDimension = 0;
            while (className.charAt(arrayDimension) == '[') {
                ++arrayDimension;
            }
            Class componentType = Reflections.loadClass(className.substring(arrayDimension), classLoader);
            return Array.newInstance(componentType, new int[arrayDimension]).getClass();
        }
    }

    public static List<Field> getAllFields(Class<?> type) {
        LinkedList<Field> fields = new LinkedList<Field>();
        fields.addAll(Arrays.asList(type.getDeclaredFields()));
        if (type.getSuperclass() != null) {
            fields.addAll(Reflections.getAllFields(type.getSuperclass()));
        }
        return fields;
    }

    static {
        PRIMITIVE_NAME_TYPE_MAP.put("boolean", Boolean.TYPE);
        PRIMITIVE_NAME_TYPE_MAP.put("byte", Byte.TYPE);
        PRIMITIVE_NAME_TYPE_MAP.put("char", Character.TYPE);
        PRIMITIVE_NAME_TYPE_MAP.put("short", Short.TYPE);
        PRIMITIVE_NAME_TYPE_MAP.put("int", Integer.TYPE);
        PRIMITIVE_NAME_TYPE_MAP.put("long", Long.TYPE);
        PRIMITIVE_NAME_TYPE_MAP.put("float", Float.TYPE);
        PRIMITIVE_NAME_TYPE_MAP.put("double", Double.TYPE);
    }
}

