/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import java.util.Optional;
import org.apache.distributedlog.BookKeeperClient;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.io.netty.channel.EventLoopGroup;
import org.apache.pulsar.shade.io.netty.util.HashedWheelTimer;
import org.apache.pulsar.shade.org.apache.bookkeeper.feature.FeatureProvider;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.StatsLogger;

public class BookKeeperClientBuilder {
    private String name = null;
    private DistributedLogConfiguration dlConfig = null;
    private ZooKeeperClient zkc = null;
    private String zkServers = null;
    private String ledgersPath = null;
    private StatsLogger statsLogger = NullStatsLogger.INSTANCE;
    private EventLoopGroup eventLoopGroup = null;
    private HashedWheelTimer requestTimer = null;
    private Optional<FeatureProvider> featureProvider = Optional.empty();
    private BookKeeperClient cachedClient = null;

    public static BookKeeperClientBuilder newBuilder() {
        return new BookKeeperClientBuilder();
    }

    private BookKeeperClientBuilder() {
    }

    public synchronized BookKeeperClientBuilder name(String name) {
        this.name = name;
        return this;
    }

    public synchronized BookKeeperClientBuilder dlConfig(DistributedLogConfiguration dlConfig) {
        this.dlConfig = dlConfig;
        return this;
    }

    public synchronized BookKeeperClientBuilder zkc(ZooKeeperClient zkc) {
        this.zkc = zkc;
        return this;
    }

    public synchronized BookKeeperClientBuilder zkServers(String zkServers) {
        this.zkServers = zkServers;
        return this;
    }

    public synchronized BookKeeperClientBuilder ledgersPath(String ledgersPath) {
        this.ledgersPath = ledgersPath;
        return this;
    }

    public synchronized BookKeeperClientBuilder bkc(BookKeeperClient bkc) {
        this.cachedClient = bkc;
        return this;
    }

    public synchronized BookKeeperClientBuilder eventLoopGroup(EventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
        return this;
    }

    public synchronized BookKeeperClientBuilder requestTimer(HashedWheelTimer requestTimer) {
        this.requestTimer = requestTimer;
        return this;
    }

    public synchronized BookKeeperClientBuilder statsLogger(StatsLogger statsLogger) {
        this.statsLogger = statsLogger;
        return this;
    }

    public synchronized BookKeeperClientBuilder featureProvider(Optional<FeatureProvider> featureProvider) {
        this.featureProvider = featureProvider;
        return this;
    }

    private void validateParameters() {
        Preconditions.checkNotNull(this.name, "Missing client name.");
        Preconditions.checkNotNull(this.dlConfig, "Missing DistributedLog Configuration.");
        Preconditions.checkArgument(null == this.zkc || null == this.zkServers, "Missing zookeeper setting.");
        Preconditions.checkNotNull(this.ledgersPath, "Missing Ledgers Root Path.");
    }

    public synchronized BookKeeperClient build() {
        if (null == this.cachedClient) {
            this.cachedClient = this.buildClient();
        }
        return this.cachedClient;
    }

    private BookKeeperClient buildClient() {
        this.validateParameters();
        return new BookKeeperClient(this.dlConfig, this.name, this.zkServers, this.zkc, this.ledgersPath, this.eventLoopGroup, this.requestTimer, this.statsLogger, this.featureProvider);
    }
}

