/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import org.apache.distributedlog.util.DLUtils;
import org.apache.pulsar.shade.org.apache.bookkeeper.versioning.Version;
import org.apache.pulsar.shade.org.apache.bookkeeper.versioning.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MaxTxId {
    static final Logger LOG = LoggerFactory.getLogger(MaxTxId.class);
    private Version version;
    private long currentMax;

    MaxTxId(Versioned<byte[]> maxTxIdData) {
        if (null != maxTxIdData && null != maxTxIdData.getValue() && null != maxTxIdData.getVersion()) {
            this.version = maxTxIdData.getVersion();
            try {
                this.currentMax = DLUtils.deserializeTransactionId(maxTxIdData.getValue());
            }
            catch (NumberFormatException e) {
                LOG.warn("Invalid txn id stored in {}", (Throwable)e);
                this.currentMax = -999L;
            }
        } else {
            this.currentMax = -999L;
            if (null != maxTxIdData && null != maxTxIdData.getVersion()) {
                this.version = maxTxIdData.getVersion();
            } else {
                throw new IllegalStateException("Invalid MaxTxId found - " + maxTxIdData);
            }
        }
    }

    synchronized void update(Version version, long txId) {
        if (version.compare(this.version) == Version.Occurred.AFTER) {
            this.version = version;
            this.currentMax = txId;
        }
    }

    synchronized long get() {
        return this.currentMax;
    }

    public synchronized Versioned<Long> getVersionedData(long txId) {
        return new Versioned<Long>(Math.max(txId, this.get()), this.version);
    }
}

