/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import java.util.List;
import java.util.Optional;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.net.DNSResolverForRacks;
import org.apache.distributedlog.net.DNSResolverForRows;
import org.apache.pulsar.shade.org.apache.bookkeeper.net.DNSToSwitchMapping;
import org.apache.pulsar.shade.org.apache.commons.configuration.StrictConfigurationComparator;
import org.junit.Assert;
import org.junit.Test;

public class TestDistributedLogConfiguration {
    @Test(timeout=20000L)
    public void loadStreamConfGoodOverrideAccepted() throws Exception {
        DistributedLogConfiguration conf = new DistributedLogConfiguration();
        Assert.assertEquals((long)conf.getPeriodicFlushFrequencyMilliSeconds(), (long)0L);
        Assert.assertEquals((long)conf.getReaderIdleErrorThresholdMillis(), (long)Integer.MAX_VALUE);
        DistributedLogConfiguration override = new DistributedLogConfiguration();
        override.setPeriodicFlushFrequencyMilliSeconds(1);
        override.setReaderIdleErrorThresholdMillis(0x7FFFFFFE);
        conf.loadStreamConf(Optional.of(override));
        Assert.assertEquals((long)conf.getPeriodicFlushFrequencyMilliSeconds(), (long)1L);
        Assert.assertEquals((long)conf.getReaderIdleErrorThresholdMillis(), (long)0x7FFFFFFEL);
    }

    @Test(timeout=20000L)
    public void loadStreamConfBadOverrideIgnored() throws Exception {
        DistributedLogConfiguration conf = new DistributedLogConfiguration();
        Assert.assertEquals((long)conf.getBKClientWriteTimeout(), (long)10L);
        DistributedLogConfiguration override = new DistributedLogConfiguration();
        override.setBKClientWriteTimeout(11);
        conf.loadStreamConf(Optional.of(override));
        Assert.assertEquals((long)conf.getBKClientWriteTimeout(), (long)10L);
    }

    @Test(timeout=20000L)
    public void loadStreamConfNullOverrides() throws Exception {
        DistributedLogConfiguration conf = new DistributedLogConfiguration();
        DistributedLogConfiguration confClone = new DistributedLogConfiguration();
        Optional<DistributedLogConfiguration> streamConfiguration = Optional.empty();
        conf.loadStreamConf(streamConfiguration);
        StrictConfigurationComparator comp = new StrictConfigurationComparator();
        Assert.assertTrue((boolean)comp.compare(conf, confClone));
    }

    @Test(timeout=200000L)
    public void getEnsemblePlacementResolverClass() throws Exception {
        DistributedLogConfiguration conf1 = new DistributedLogConfiguration();
        Assert.assertEquals(DNSResolverForRacks.class, conf1.getEnsemblePlacementDnsResolverClass());
        DistributedLogConfiguration conf2 = new DistributedLogConfiguration().setRowAwareEnsemblePlacementEnabled(true);
        Assert.assertEquals(DNSResolverForRows.class, conf2.getEnsemblePlacementDnsResolverClass());
        DistributedLogConfiguration conf3 = new DistributedLogConfiguration().setRowAwareEnsemblePlacementEnabled(true).setEnsemblePlacementDnsResolverClass(TestDNSResolver.class);
        Assert.assertEquals(TestDNSResolver.class, conf3.getEnsemblePlacementDnsResolverClass());
    }

    @Test(timeout=200000L)
    public void validateConfiguration() {
        boolean exceptionThrown = false;
        DistributedLogConfiguration conf = new DistributedLogConfiguration();
        conf.validate();
        conf.setReadLACLongPollTimeout(conf.getBKClientReadTimeout() * 1000);
        try {
            conf.validate();
        }
        catch (IllegalArgumentException e) {
            exceptionThrown = true;
        }
        Assert.assertFalse((boolean)exceptionThrown);
        exceptionThrown = false;
        conf.setReadLACLongPollTimeout(conf.getBKClientReadTimeout() * 1000 * 2);
        try {
            conf.validate();
        }
        catch (IllegalArgumentException e) {
            exceptionThrown = true;
        }
        Assert.assertTrue((boolean)exceptionThrown);
    }

    static final class TestDNSResolver
    implements DNSToSwitchMapping {
        @Override
        public List<String> resolve(List<String> list) {
            return list;
        }

        @Override
        public void reloadCachedMappings() {
        }
    }
}

