/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import java.net.URI;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.distributedlog.impl.BKNamespaceDriver;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.StatsLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.zookeeper.RetryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperClientBuilder {
    static final Logger LOG = LoggerFactory.getLogger(ZooKeeperClientBuilder.class);
    private String name = "default";
    private int sessionTimeoutMs = -1;
    private int conectionTimeoutMs = -1;
    private String zkServers = null;
    private RetryPolicy retryPolicy = null;
    private StatsLogger statsLogger = NullStatsLogger.INSTANCE;
    private int retryThreadCount = 1;
    private double requestRateLimit = 0.0;
    private boolean zkAclIdSet = false;
    private String zkAclId;
    private ZooKeeperClient cachedClient = null;

    public static ZooKeeperClientBuilder newBuilder() {
        return new ZooKeeperClientBuilder();
    }

    private ZooKeeperClientBuilder() {
    }

    public synchronized ZooKeeperClientBuilder name(String name) {
        this.name = name;
        return this;
    }

    public synchronized ZooKeeperClientBuilder sessionTimeoutMs(int sessionTimeoutMs) {
        this.sessionTimeoutMs = sessionTimeoutMs;
        if (this.conectionTimeoutMs <= 0) {
            this.conectionTimeoutMs = 2 * sessionTimeoutMs;
        }
        return this;
    }

    public synchronized ZooKeeperClientBuilder retryThreadCount(int retryThreadCount) {
        this.retryThreadCount = retryThreadCount;
        return this;
    }

    public synchronized ZooKeeperClientBuilder requestRateLimit(double requestRateLimit) {
        this.requestRateLimit = requestRateLimit;
        return this;
    }

    public synchronized ZooKeeperClientBuilder connectionTimeoutMs(int connectionTimeoutMs) {
        this.conectionTimeoutMs = connectionTimeoutMs;
        return this;
    }

    public synchronized ZooKeeperClientBuilder zkServers(String zkServers) {
        this.zkServers = zkServers;
        return this;
    }

    public synchronized ZooKeeperClientBuilder uri(URI uri) {
        this.zkServers = BKNamespaceDriver.getZKServersFromDLUri(uri);
        return this;
    }

    public synchronized ZooKeeperClientBuilder zkc(ZooKeeperClient zkc) {
        this.cachedClient = zkc;
        return this;
    }

    public synchronized ZooKeeperClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public synchronized ZooKeeperClientBuilder statsLogger(StatsLogger statsLogger) {
        this.statsLogger = statsLogger;
        return this;
    }

    public synchronized ZooKeeperClientBuilder zkAclId(String zkAclId) {
        this.zkAclIdSet = true;
        this.zkAclId = zkAclId;
        return this;
    }

    private void validateParameters() {
        Preconditions.checkNotNull(this.zkServers, "No zk servers provided.");
        Preconditions.checkArgument(this.conectionTimeoutMs > 0, "Invalid connection timeout : %d", this.conectionTimeoutMs);
        Preconditions.checkArgument(this.sessionTimeoutMs > 0, "Invalid session timeout : %d", this.sessionTimeoutMs);
        Preconditions.checkNotNull(this.statsLogger, "No stats logger provided.");
        Preconditions.checkArgument(this.zkAclIdSet, "Zookeeper acl id not set.");
    }

    public synchronized ZooKeeperClient build() {
        if (null == this.cachedClient) {
            this.cachedClient = this.buildClient();
        }
        return this.cachedClient;
    }

    private ZooKeeperClient buildClient() {
        this.validateParameters();
        ZooKeeperClient.Credentials credentials = ZooKeeperClient.Credentials.NONE;
        if (null != this.zkAclId) {
            credentials = new ZooKeeperClient.DigestCredentials(this.zkAclId, this.zkAclId);
        }
        return new ZooKeeperClient(this.name, this.sessionTimeoutMs, this.conectionTimeoutMs, this.zkServers, this.retryPolicy, this.statsLogger, this.retryThreadCount, this.requestRateLimit, credentials);
    }
}

