/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import java.io.File;
import org.apache.distributedlog.LocalDLMEmulator;
import org.apache.pulsar.shade.org.apache.bookkeeper.shims.zk.ZooKeeperServerShim;
import org.apache.pulsar.shade.org.apache.bookkeeper.util.IOUtils;
import org.apache.pulsar.shade.org.apache.commons.io.FileUtils;
import org.apache.pulsar.shade.org.apache.commons.lang3.tuple.Pair;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperClusterTestCase {
    private static final Logger log = LoggerFactory.getLogger(ZooKeeperClusterTestCase.class);
    protected static File zkDir;
    protected static ZooKeeperServerShim zks;
    protected static String zkServers;
    protected static int zkPort;

    @BeforeClass
    public static void setupZooKeeper() throws Exception {
        zkDir = IOUtils.createTempDir("zookeeper", ZooKeeperClusterTestCase.class.getName());
        Pair<ZooKeeperServerShim, Integer> serverAndPort = LocalDLMEmulator.runZookeeperOnAnyPort(zkDir);
        zks = serverAndPort.getLeft();
        zkPort = serverAndPort.getRight();
        zkServers = "127.0.0.1:" + zkPort;
        log.info("--- Setup zookeeper at {} ---", (Object)zkServers);
    }

    @AfterClass
    public static void shutdownZooKeeper() throws Exception {
        log.info("--- Shutdown zookeeper at {} ---", (Object)zkServers);
        zks.stop();
        if (null != zkDir) {
            FileUtils.forceDeleteOnExit(zkDir);
        }
    }

    static {
        System.setProperty("zookeeper.4lw.commands.whitelist", "*");
    }
}

