/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.lock;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.distributedlog.DLMTestUtil;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.distributedlog.ZooKeeperClientBuilder;
import org.apache.distributedlog.ZooKeeperClientUtils;
import org.apache.distributedlog.ZooKeeperClusterTestCase;
import org.apache.distributedlog.exceptions.LockingException;
import org.apache.distributedlog.exceptions.OwnershipAcquireFailedException;
import org.apache.distributedlog.lock.DistributedLockContext;
import org.apache.distributedlog.lock.EpochChangedException;
import org.apache.distributedlog.lock.LockAction;
import org.apache.distributedlog.lock.LockClosedException;
import org.apache.distributedlog.lock.LockListener;
import org.apache.distributedlog.lock.LockStateChangedException;
import org.apache.distributedlog.lock.ZKSessionLock;
import org.apache.distributedlog.util.FailpointUtils;
import org.apache.distributedlog.util.Utils;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.pulsar.shade.org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.shade.org.apache.zookeeper.CreateMode;
import org.apache.pulsar.shade.org.apache.zookeeper.KeeperException;
import org.apache.pulsar.shade.org.apache.zookeeper.ZooDefs;
import org.apache.pulsar.shade.org.apache.zookeeper.ZooKeeper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestZKSessionLock
extends ZooKeeperClusterTestCase {
    @Rule
    public TestName testNames = new TestName();
    private static final Logger logger = LoggerFactory.getLogger(TestZKSessionLock.class);
    private static final int sessionTimeoutMs = 2000;
    private ZooKeeperClient zkc;
    private ZooKeeperClient zkc0;
    private OrderedScheduler lockStateExecutor;

    @Before
    public void setup() throws Exception {
        this.zkc = ZooKeeperClientBuilder.newBuilder().name("zkc").uri(DLMTestUtil.createDLMURI(zkPort, "/")).sessionTimeoutMs(2000).zkServers(zkServers).zkAclId(null).build();
        this.zkc0 = ZooKeeperClientBuilder.newBuilder().name("zkc0").uri(DLMTestUtil.createDLMURI(zkPort, "/")).sessionTimeoutMs(2000).zkServers(zkServers).zkAclId(null).build();
        this.lockStateExecutor = (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().numThreads(1).build();
    }

    @After
    public void teardown() throws Exception {
        this.zkc.close();
        this.zkc0.close();
        this.lockStateExecutor.shutdown();
    }

    private static void createLockPath(ZooKeeper zk, String lockPath) throws Exception {
        zk.create(lockPath, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
    }

    private static String createLockNodeV1(ZooKeeper zk, String lockPath, String clientId) throws Exception {
        return zk.create(ZKSessionLock.getLockPathPrefixV1(lockPath), ZKSessionLock.serializeClientId(clientId), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
    }

    private static String createLockNodeV2(ZooKeeper zk, String lockPath, String clientId) throws Exception {
        return zk.create(ZKSessionLock.getLockPathPrefixV2(lockPath, clientId), ZKSessionLock.serializeClientId(clientId), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
    }

    private static String createLockNodeV3(ZooKeeper zk, String lockPath, String clientId) throws Exception {
        return zk.create(ZKSessionLock.getLockPathPrefixV3(lockPath, clientId, zk.getSessionId()), ZKSessionLock.serializeClientId(clientId), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
    }

    private static String createLockNodeWithBadNodeName(ZooKeeper zk, String lockPath, String clientId, String badNodeName) throws Exception {
        return zk.create(lockPath + "/" + badNodeName, ZKSessionLock.serializeClientId(clientId), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
    }

    private static List<String> getLockWaiters(ZooKeeperClient zkc, String lockPath) throws Exception {
        List<String> children = zkc.get().getChildren(lockPath, false);
        Collections.sort(children, ZKSessionLock.MEMBER_COMPARATOR);
        return children;
    }

    @Test(timeout=60000L)
    public void testParseClientID() throws Exception {
        ZooKeeper zk = this.zkc.get();
        String lockPath = "/test-parse-clientid";
        String clientId = "test-parse-clientid-" + System.currentTimeMillis();
        Pair<String, Long> lockId = Pair.of(clientId, zk.getSessionId());
        TestZKSessionLock.createLockPath(zk, lockPath);
        String node1 = ZKSessionLock.getLockIdFromPath(TestZKSessionLock.createLockNodeV1(zk, lockPath, clientId));
        String node2 = ZKSessionLock.getLockIdFromPath(TestZKSessionLock.createLockNodeV2(zk, lockPath, clientId));
        String node3 = ZKSessionLock.getLockIdFromPath(TestZKSessionLock.createLockNodeV3(zk, lockPath, clientId));
        Assert.assertEquals(lockId, Utils.ioResult(ZKSessionLock.asyncParseClientID(zk, lockPath, node1)));
        Assert.assertEquals(lockId, Utils.ioResult(ZKSessionLock.asyncParseClientID(zk, lockPath, node2)));
        Assert.assertEquals(lockId, Utils.ioResult(ZKSessionLock.asyncParseClientID(zk, lockPath, node3)));
        String node4 = ZKSessionLock.getLockIdFromPath(TestZKSessionLock.createLockNodeWithBadNodeName(zk, lockPath, clientId, "member"));
        String node5 = ZKSessionLock.getLockIdFromPath(TestZKSessionLock.createLockNodeWithBadNodeName(zk, lockPath, clientId, "member_badnode"));
        String node6 = ZKSessionLock.getLockIdFromPath(TestZKSessionLock.createLockNodeWithBadNodeName(zk, lockPath, clientId, "member_badnode_badnode"));
        String node7 = ZKSessionLock.getLockIdFromPath(TestZKSessionLock.createLockNodeWithBadNodeName(zk, lockPath, clientId, "member_badnode_badnode_badnode"));
        String node8 = ZKSessionLock.getLockIdFromPath(TestZKSessionLock.createLockNodeWithBadNodeName(zk, lockPath, clientId, "member_badnode_badnode_badnode_badnode"));
        Assert.assertEquals(lockId, Utils.ioResult(ZKSessionLock.asyncParseClientID(zk, lockPath, node4)));
        Assert.assertEquals(lockId, Utils.ioResult(ZKSessionLock.asyncParseClientID(zk, lockPath, node5)));
        Assert.assertEquals(lockId, Utils.ioResult(ZKSessionLock.asyncParseClientID(zk, lockPath, node6)));
        Assert.assertEquals(lockId, Utils.ioResult(ZKSessionLock.asyncParseClientID(zk, lockPath, node7)));
        Assert.assertEquals(lockId, Utils.ioResult(ZKSessionLock.asyncParseClientID(zk, lockPath, node8)));
        String node9 = ZKSessionLock.getLockIdFromPath(TestZKSessionLock.createLockNodeWithBadNodeName(zk, lockPath, clientId, "member_malformed_s12345678_999999"));
        Assert.assertEquals(Pair.of("malformed", 12345678L), Utils.ioResult(ZKSessionLock.asyncParseClientID(zk, lockPath, node9)));
    }

    @Test(timeout=60000L)
    public void testParseMemberID() throws Exception {
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)ZKSessionLock.parseMemberID("badnode"));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)ZKSessionLock.parseMemberID("badnode_badnode"));
        Assert.assertEquals((long)0L, (long)ZKSessionLock.parseMemberID("member_000000"));
        Assert.assertEquals((long)123L, (long)ZKSessionLock.parseMemberID("member_000123"));
    }

    @Test(timeout=60000L)
    public void testAreLockWaitersInSameSession() throws Exception {
        ZooKeeper zk = this.zkc.get();
        String lockPath = "/test-are-lock-waiters-in-same-session";
        String clientId1 = "test-are-lock-waiters-in-same-session-1";
        String clientId2 = "test-are-lock-waiters-in-same-session-2";
        TestZKSessionLock.createLockPath(zk, lockPath);
        String node1 = ZKSessionLock.getLockIdFromPath(TestZKSessionLock.createLockNodeV3(zk, lockPath, clientId1));
        String node2 = ZKSessionLock.getLockIdFromPath(TestZKSessionLock.createLockNodeV3(zk, lockPath, clientId2));
        String node3 = ZKSessionLock.getLockIdFromPath(TestZKSessionLock.createLockNodeV3(zk, lockPath, clientId1));
        Assert.assertEquals((String)(node1 + " and " + node3 + " should be in same session."), (Object)true, (Object)ZKSessionLock.areLockWaitersInSameSession(node1, node3));
        Assert.assertEquals((String)(node1 + " and " + node2 + " should be not in same session."), (Object)false, (Object)ZKSessionLock.areLockWaitersInSameSession(node1, node2));
        Assert.assertEquals((String)(node3 + " and " + node2 + " should be not in same session."), (Object)false, (Object)ZKSessionLock.areLockWaitersInSameSession(node3, node2));
    }

    @Test(timeout=60000L)
    public void testExecuteLockAction() throws Exception {
        String lockPath = "/test-execute-lock-action";
        String clientId = "test-execute-lock-action-" + System.currentTimeMillis();
        ZKSessionLock lock = new ZKSessionLock(this.zkc, lockPath, clientId, this.lockStateExecutor);
        final AtomicInteger counter = new AtomicInteger(0);
        final CountDownLatch latch1 = new CountDownLatch(1);
        lock.executeLockAction(lock.getEpoch(), new LockAction(){

            @Override
            public void execute() {
                counter.incrementAndGet();
                latch1.countDown();
            }

            @Override
            public String getActionName() {
                return "increment1";
            }
        });
        latch1.await();
        Assert.assertEquals((String)"counter should be increased in same epoch", (long)1L, (long)counter.get());
        final CountDownLatch latch2 = new CountDownLatch(1);
        lock.executeLockAction(lock.getEpoch() + 1, new LockAction(){

            @Override
            public void execute() {
                counter.incrementAndGet();
            }

            @Override
            public String getActionName() {
                return "increment2";
            }
        });
        lock.executeLockAction(lock.getEpoch(), new LockAction(){

            @Override
            public void execute() {
                latch2.countDown();
            }

            @Override
            public String getActionName() {
                return "countdown";
            }
        });
        latch2.await();
        Assert.assertEquals((String)"counter should not be increased in different epochs", (long)1L, (long)counter.get());
        CompletableFuture promise = new CompletableFuture();
        lock.executeLockAction(lock.getEpoch() + 1, new LockAction(){

            @Override
            public void execute() {
                counter.incrementAndGet();
            }

            @Override
            public String getActionName() {
                return "increment3";
            }
        }, promise);
        try {
            Utils.ioResult(promise);
            Assert.fail((String)"Should satisfy promise with epoch changed exception.");
        }
        catch (EpochChangedException epochChangedException) {
            // empty catch block
        }
        Assert.assertEquals((String)"counter should not be increased in different epochs", (long)1L, (long)counter.get());
        this.lockStateExecutor.shutdown();
    }

    @Test(timeout=60000L)
    public void testLockAfterUnlock() throws Exception {
        String lockPath = "/test-lock-after-unlock";
        String clientId = "test-lock-after-unlock";
        ZKSessionLock lock = new ZKSessionLock(this.zkc, lockPath, clientId, this.lockStateExecutor);
        lock.unlock();
        Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLOSED), (Object)((Object)lock.getLockState()));
        try {
            lock.tryLock(0L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"Should fail on tryLock since lock state has changed.");
        }
        catch (LockStateChangedException lockStateChangedException) {
            // empty catch block
        }
        Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLOSED), (Object)((Object)lock.getLockState()));
        try {
            lock.tryLock(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            Assert.fail((String)"Should fail on tryLock immediately if lock state has changed.");
        }
        catch (LockStateChangedException lockStateChangedException) {
            // empty catch block
        }
        Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLOSED), (Object)((Object)lock.getLockState()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testUnlockTimeout() throws Exception {
        String name = this.testNames.getMethodName();
        String lockPath = "/" + name;
        String clientId = name;
        TestZKSessionLock.createLockPath(this.zkc.get(), lockPath);
        ZKSessionLock lock = new ZKSessionLock(this.zkc, lockPath, clientId, this.lockStateExecutor, 1000L, NullStatsLogger.INSTANCE, new DistributedLockContext());
        lock.tryLock(0L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLAIMED), (Object)((Object)lock.getLockState()));
        try {
            FailpointUtils.setFailpoint(FailpointUtils.FailPointName.FP_LockUnlockCleanup, new DelayFailpointAction(3600000L));
            lock.unlock();
            Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLOSING), (Object)((Object)lock.getLockState()));
        }
        finally {
            FailpointUtils.removeFailpoint(FailpointUtils.FailPointName.FP_LockUnlockCleanup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testTryCloseRaceCondition() throws Exception {
        String name = this.testNames.getMethodName();
        String lockPath = "/" + name;
        String clientId = name;
        TestZKSessionLock.createLockPath(this.zkc.get(), lockPath);
        ZKSessionLock lock = new ZKSessionLock(this.zkc, lockPath, clientId, this.lockStateExecutor, 1000L, NullStatsLogger.INSTANCE, new DistributedLockContext());
        try {
            FailpointUtils.setFailpoint(FailpointUtils.FailPointName.FP_LockTryCloseRaceCondition, FailpointUtils.DEFAULT_ACTION);
            lock.tryLock(0L, TimeUnit.MILLISECONDS);
        }
        catch (LockClosedException lockClosedException) {
        }
        finally {
            FailpointUtils.removeFailpoint(FailpointUtils.FailPointName.FP_LockTryCloseRaceCondition);
        }
        Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLOSED), (Object)((Object)lock.getLockState()));
        List<String> children = TestZKSessionLock.getLockWaiters(this.zkc, lockPath);
        Assert.assertEquals((long)0L, (long)children.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testTryAcquireTimeout() throws Exception {
        String name = this.testNames.getMethodName();
        String lockPath = "/" + name;
        String clientId = name;
        TestZKSessionLock.createLockPath(this.zkc.get(), lockPath);
        ZKSessionLock lock = new ZKSessionLock(this.zkc, lockPath, clientId, this.lockStateExecutor, 1L, NullStatsLogger.INSTANCE, new DistributedLockContext());
        try {
            FailpointUtils.setFailpoint(FailpointUtils.FailPointName.FP_LockTryAcquire, new DelayFailpointAction(3600000L));
            lock.tryLock(0L, TimeUnit.MILLISECONDS);
            Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLOSED), (Object)((Object)lock.getLockState()));
        }
        catch (LockingException lockingException) {
        }
        catch (Exception e) {
            Assert.fail((String)"expected locking exception");
        }
        finally {
            FailpointUtils.removeFailpoint(FailpointUtils.FailPointName.FP_LockTryAcquire);
        }
    }

    @Test(timeout=60000L)
    public void testBasicLockUnlock0() throws Exception {
        this.testBasicLockUnlock(0L);
    }

    @Test(timeout=60000L)
    public void testBasicLockUnlock1() throws Exception {
        this.testBasicLockUnlock(Long.MAX_VALUE);
    }

    private void testBasicLockUnlock(long timeout) throws Exception {
        String lockPath = "/test-basic-lock-unlock-" + timeout + System.currentTimeMillis();
        String clientId = "test-basic-lock-unlock";
        TestZKSessionLock.createLockPath(this.zkc.get(), lockPath);
        ZKSessionLock lock = new ZKSessionLock(this.zkc, lockPath, clientId, this.lockStateExecutor);
        lock.tryLock(timeout, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLAIMED), (Object)((Object)lock.getLockState()));
        List<String> children = TestZKSessionLock.getLockWaiters(this.zkc, lockPath);
        Assert.assertEquals((long)1L, (long)children.size());
        Assert.assertEquals(lock.getLockId(), Utils.ioResult(ZKSessionLock.asyncParseClientID(this.zkc.get(), lockPath, children.get(0))));
        try {
            lock.tryLock(timeout, TimeUnit.MILLISECONDS);
            Assert.fail((String)"Should fail on locking a failure lock.");
        }
        catch (LockStateChangedException lockStateChangedException) {
            // empty catch block
        }
        Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLAIMED), (Object)((Object)lock.getLockState()));
        children = TestZKSessionLock.getLockWaiters(this.zkc, lockPath);
        Assert.assertEquals((long)1L, (long)children.size());
        Assert.assertEquals(lock.getLockId(), Utils.ioResult(ZKSessionLock.asyncParseClientID(this.zkc.get(), lockPath, children.get(0))));
        lock.unlock();
        Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLOSED), (Object)((Object)lock.getLockState()));
        Assert.assertEquals((long)0L, (long)TestZKSessionLock.getLockWaiters(this.zkc, lockPath).size());
    }

    @Test(timeout=60000L)
    public void testLockOnNonExistedLock() throws Exception {
        String lockPath = "/test-lock-on-non-existed-lock";
        String clientId = "test-lock-on-non-existed-lock";
        ZKSessionLock lock = new ZKSessionLock(this.zkc, lockPath, clientId, this.lockStateExecutor);
        try {
            lock.tryLock(0L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"Should fail on locking a non-existed lock.");
        }
        catch (LockingException le) {
            Throwable cause = le.getCause();
            Assert.assertTrue((boolean)(cause instanceof KeeperException));
            Assert.assertEquals((Object)KeeperException.Code.NONODE, (Object)((KeeperException)cause).code());
        }
        Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLOSED), (Object)((Object)lock.getLockState()));
        try {
            lock.tryLock(0L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"Should fail on locking a failure lock.");
        }
        catch (LockStateChangedException lockStateChangedException) {
            // empty catch block
        }
        Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLOSED), (Object)((Object)lock.getLockState()));
    }

    @Test(timeout=60000L)
    public void testLockWhenSomeoneHeldLock0() throws Exception {
        this.testLockWhenSomeoneHeldLock(0L);
    }

    @Test(timeout=60000L)
    public void testLockWhenSomeoneHeldLock1() throws Exception {
        this.testLockWhenSomeoneHeldLock(500L);
    }

    private void testLockWhenSomeoneHeldLock(long timeout) throws Exception {
        String lockPath = "/test-lock-nowait-" + timeout + "-" + System.currentTimeMillis();
        String clientId0 = "test-lock-nowait-0-" + System.currentTimeMillis();
        String clientId1 = "test-lock-nowait-1-" + System.currentTimeMillis();
        String clientId2 = "test-lock-nowait-2-" + System.currentTimeMillis();
        TestZKSessionLock.createLockPath(this.zkc.get(), lockPath);
        ZKSessionLock lock0 = new ZKSessionLock(this.zkc0, lockPath, clientId0, this.lockStateExecutor);
        ZKSessionLock lock1 = new ZKSessionLock(this.zkc, lockPath, clientId1, this.lockStateExecutor);
        lock0.tryLock(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLAIMED), (Object)((Object)lock0.getLockState()));
        List<String> children = TestZKSessionLock.getLockWaiters(this.zkc0, lockPath);
        Assert.assertEquals((long)1L, (long)children.size());
        Assert.assertEquals(lock0.getLockId(), Utils.ioResult(ZKSessionLock.asyncParseClientID(this.zkc0.get(), lockPath, children.get(0))));
        try {
            lock1.tryLock(timeout, TimeUnit.MILLISECONDS);
            Assert.fail((String)"lock1 should fail on locking since lock0 is holding the lock.");
        }
        catch (OwnershipAcquireFailedException oafe) {
            Assert.assertEquals((Object)lock0.getLockId().getLeft(), (Object)oafe.getCurrentOwner());
        }
        Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLAIMED), (Object)((Object)lock0.getLockState()));
        Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLOSED), (Object)((Object)lock1.getLockState()));
        children = TestZKSessionLock.getLockWaiters(this.zkc0, lockPath);
        Assert.assertEquals((long)1L, (long)children.size());
        Assert.assertEquals(lock0.getLockId(), Utils.ioResult(ZKSessionLock.asyncParseClientID(this.zkc0.get(), lockPath, children.get(0))));
        lock0.unlock();
        Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLOSED), (Object)((Object)lock0.getLockState()));
        Assert.assertEquals((long)0L, (long)TestZKSessionLock.getLockWaiters(this.zkc, lockPath).size());
        ZKSessionLock lock2 = new ZKSessionLock(this.zkc, lockPath, clientId2, this.lockStateExecutor);
        lock2.tryLock(timeout, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLOSED), (Object)((Object)lock0.getLockState()));
        Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLOSED), (Object)((Object)lock1.getLockState()));
        Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLAIMED), (Object)((Object)lock2.getLockState()));
        children = TestZKSessionLock.getLockWaiters(this.zkc, lockPath);
        Assert.assertEquals((long)1L, (long)children.size());
        Assert.assertEquals(lock2.getLockId(), Utils.ioResult(ZKSessionLock.asyncParseClientID(this.zkc.get(), lockPath, children.get(0))));
        lock2.unlock();
    }

    @Test(timeout=60000L)
    public void testLockWhenPreviousLockZnodeStillExists() throws Exception {
        String lockPath = "/test-lock-when-previous-lock-znode-still-exists-" + System.currentTimeMillis();
        String clientId = "client-id";
        ZooKeeper zk = this.zkc.get();
        TestZKSessionLock.createLockPath(zk, lockPath);
        ZKSessionLock lock0 = new ZKSessionLock(this.zkc0, lockPath, clientId, this.lockStateExecutor);
        lock0.tryLock(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        DistributedLockContext context1 = new DistributedLockContext();
        context1.addLockId(lock0.getLockId());
        ZKSessionLock lock1 = new ZKSessionLock(this.zkc, lockPath, clientId, this.lockStateExecutor, 60000L, NullStatsLogger.INSTANCE, context1);
        lock1.tryLock(0L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLAIMED), (Object)((Object)lock1.getLockState()));
        lock1.unlock();
        DistributedLockContext context2 = new DistributedLockContext();
        context2.addLockId(lock0.getLockId());
        ZKSessionLock lock2 = new ZKSessionLock(this.zkc, lockPath, clientId, this.lockStateExecutor, 60000L, NullStatsLogger.INSTANCE, context2);
        lock2.tryLock(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLAIMED), (Object)((Object)lock2.getLockState()));
        lock2.unlock();
        lock0.unlock();
    }

    @Test(timeout=60000L)
    public void testWaitForLockUnlock() throws Exception {
        this.testWaitForLockReleased("/test-wait-for-lock-unlock", true);
    }

    @Test(timeout=60000L)
    public void testWaitForLockExpired() throws Exception {
        this.testWaitForLockReleased("/test-wait-for-lock-expired", false);
    }

    private void testWaitForLockReleased(String lockPath, boolean isUnlock) throws Exception {
        String clientId0 = "test-wait-for-lock-released-0-" + System.currentTimeMillis();
        String clientId1 = "test-wait-for-lock-released-1-" + System.currentTimeMillis();
        TestZKSessionLock.createLockPath(this.zkc.get(), lockPath);
        ZKSessionLock lock0 = new ZKSessionLock(this.zkc0, lockPath, clientId0, this.lockStateExecutor);
        final ZKSessionLock lock1 = new ZKSessionLock(this.zkc, lockPath, clientId1, this.lockStateExecutor);
        lock0.tryLock(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLAIMED), (Object)((Object)lock0.getLockState()));
        List<String> children = TestZKSessionLock.getLockWaiters(this.zkc0, lockPath);
        Assert.assertEquals((long)1L, (long)children.size());
        Assert.assertEquals(lock0.getLockId(), Utils.ioResult(ZKSessionLock.asyncParseClientID(this.zkc0.get(), lockPath, children.get(0))));
        final CountDownLatch lock1DoneLatch = new CountDownLatch(1);
        Thread lock1Thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    lock1.tryLock(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                    lock1DoneLatch.countDown();
                }
                catch (LockingException e) {
                    logger.error("Failed on locking lock1 : ", (Throwable)e);
                }
            }
        }, "lock1-thread");
        lock1Thread.start();
        children = this.awaitWaiters(2, this.zkc, lockPath);
        if (isUnlock) {
            lock0.unlock();
        } else {
            ZooKeeperClientUtils.expireSession(this.zkc0, zkServers, 2000);
        }
        lock1DoneLatch.await();
        lock1Thread.join();
        if (isUnlock) {
            Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLOSED), (Object)((Object)lock0.getLockState()));
        } else {
            Assert.assertEquals((Object)((Object)ZKSessionLock.State.EXPIRED), (Object)((Object)lock0.getLockState()));
        }
        Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLAIMED), (Object)((Object)lock1.getLockState()));
        children = TestZKSessionLock.getLockWaiters(this.zkc, lockPath);
        Assert.assertEquals((long)1L, (long)children.size());
        Assert.assertEquals(lock1.getLockId(), Utils.ioResult(ZKSessionLock.asyncParseClientID(this.zkc.get(), lockPath, children.get(0))));
        lock1.unlock();
    }

    @Test(timeout=60000L)
    public void testLockListenerOnExpired() throws Exception {
        String lockPath = "/test-lock-listener-on-expired";
        String clientId = "test-lock-listener-on-expired-" + System.currentTimeMillis();
        TestZKSessionLock.createLockPath(this.zkc.get(), lockPath);
        final CountDownLatch expiredLatch = new CountDownLatch(1);
        LockListener listener = new LockListener(){

            @Override
            public void onExpired() {
                expiredLatch.countDown();
            }
        };
        ZKSessionLock lock = new ZKSessionLock(this.zkc, lockPath, clientId, this.lockStateExecutor).setLockListener(listener);
        lock.tryLock(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLAIMED), (Object)((Object)lock.getLockState()));
        List<String> children = TestZKSessionLock.getLockWaiters(this.zkc, lockPath);
        Assert.assertEquals((long)1L, (long)children.size());
        Assert.assertEquals(lock.getLockId(), Utils.ioResult(ZKSessionLock.asyncParseClientID(this.zkc.get(), lockPath, children.get(0))));
        ZooKeeperClientUtils.expireSession(this.zkc, zkServers, 2000);
        expiredLatch.await();
        Assert.assertEquals((Object)((Object)ZKSessionLock.State.EXPIRED), (Object)((Object)lock.getLockState()));
        children = TestZKSessionLock.getLockWaiters(this.zkc, lockPath);
        Assert.assertEquals((long)0L, (long)children.size());
        try {
            lock.tryLock(0L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"Should fail on tryLock since lock state has changed.");
        }
        catch (LockStateChangedException lockStateChangedException) {
            // empty catch block
        }
        lock.unlock();
    }

    @Test(timeout=60000L)
    public void testSessionExpiredBeforeLock0() throws Exception {
        this.testSessionExpiredBeforeLock(0L);
    }

    @Test(timeout=60000L)
    public void testSessionExpiredBeforeLock1() throws Exception {
        this.testSessionExpiredBeforeLock(Long.MAX_VALUE);
    }

    private void testSessionExpiredBeforeLock(long timeout) throws Exception {
        String lockPath = "/test-session-expired-before-lock-" + timeout + "-" + System.currentTimeMillis();
        String clientId = "test-session-expired-before-lock-" + System.currentTimeMillis();
        TestZKSessionLock.createLockPath(this.zkc.get(), lockPath);
        final AtomicInteger expireCounter = new AtomicInteger(0);
        CountDownLatch expiredLatch = new CountDownLatch(1);
        LockListener listener = new LockListener(){

            @Override
            public void onExpired() {
                expireCounter.incrementAndGet();
            }
        };
        ZKSessionLock lock = new ZKSessionLock(this.zkc, lockPath, clientId, this.lockStateExecutor).setLockListener(listener);
        ZooKeeperClientUtils.expireSession(this.zkc, zkServers, 2000);
        this.lockStateExecutor.executeOrdered(lockPath, () -> expiredLatch.countDown());
        expiredLatch.await();
        Assert.assertEquals((Object)((Object)ZKSessionLock.State.INIT), (Object)((Object)lock.getLockState()));
        try {
            lock.tryLock(timeout, TimeUnit.MILLISECONDS);
            Assert.fail((String)"Should fail locking using an expired lock");
        }
        catch (LockingException le) {
            Assert.assertTrue((boolean)(le.getCause() instanceof KeeperException.SessionExpiredException));
        }
        Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLOSED), (Object)((Object)lock.getLockState()));
        List<String> children = TestZKSessionLock.getLockWaiters(this.zkc, lockPath);
        Assert.assertEquals((long)0L, (long)children.size());
    }

    @Test(timeout=60000L)
    public void testSessionExpiredForLockWaiter() throws Exception {
        String lockPath = "/test-session-expired-for-lock-waiter";
        String clientId0 = "test-session-expired-for-lock-waiter-0";
        String clientId1 = "test-session-expired-for-lock-waiter-1";
        TestZKSessionLock.createLockPath(this.zkc.get(), lockPath);
        ZKSessionLock lock0 = new ZKSessionLock(this.zkc0, lockPath, clientId0, this.lockStateExecutor);
        lock0.tryLock(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLAIMED), (Object)((Object)lock0.getLockState()));
        List<String> children = TestZKSessionLock.getLockWaiters(this.zkc0, lockPath);
        Assert.assertEquals((long)1L, (long)children.size());
        Assert.assertEquals(lock0.getLockId(), Utils.ioResult(ZKSessionLock.asyncParseClientID(this.zkc0.get(), lockPath, children.get(0))));
        final ZKSessionLock lock1 = new ZKSessionLock(this.zkc, lockPath, clientId1, this.lockStateExecutor);
        final CountDownLatch lock1DoneLatch = new CountDownLatch(1);
        Thread lock1Thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    lock1.tryLock(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                }
                catch (OwnershipAcquireFailedException oafe) {
                    lock1DoneLatch.countDown();
                }
                catch (LockingException e) {
                    logger.error("Failed on locking lock1 : ", (Throwable)e);
                }
            }
        }, "lock1-thread");
        lock1Thread.start();
        children = this.awaitWaiters(2, this.zkc, lockPath);
        Assert.assertEquals((long)2L, (long)children.size());
        Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLAIMED), (Object)((Object)lock0.getLockState()));
        Assert.assertEquals(lock0.getLockId(), Utils.ioResult(ZKSessionLock.asyncParseClientID(this.zkc0.get(), lockPath, children.get(0))));
        this.awaitState(ZKSessionLock.State.WAITING, lock1);
        Assert.assertEquals(lock1.getLockId(), Utils.ioResult(ZKSessionLock.asyncParseClientID(this.zkc.get(), lockPath, children.get(1))));
        ZooKeeperClientUtils.expireSession(this.zkc, zkServers, 2000);
        lock1DoneLatch.countDown();
        lock1Thread.join();
        Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLAIMED), (Object)((Object)lock0.getLockState()));
        Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLOSED), (Object)((Object)lock1.getLockState()));
        children = TestZKSessionLock.getLockWaiters(this.zkc0, lockPath);
        Assert.assertEquals((long)1L, (long)children.size());
        Assert.assertEquals(lock0.getLockId(), Utils.ioResult(ZKSessionLock.asyncParseClientID(this.zkc0.get(), lockPath, children.get(0))));
    }

    public void awaitState(ZKSessionLock.State state, ZKSessionLock lock) throws InterruptedException {
        while (lock.getLockState() != state) {
            Thread.sleep(50L);
        }
    }

    public List<String> awaitWaiters(int waiters, ZooKeeperClient zkc, String lockPath) throws Exception {
        List<String> children = TestZKSessionLock.getLockWaiters(zkc, lockPath);
        while (children.size() < waiters) {
            Thread.sleep(50L);
            children = TestZKSessionLock.getLockWaiters(zkc, lockPath);
        }
        return children;
    }

    @Test(timeout=60000L)
    public void testLockUseSameClientIdButDifferentSessions0() throws Exception {
        this.testLockUseSameClientIdButDifferentSessions(true);
    }

    @Test(timeout=60000L)
    public void testLockUseSameClientIdButDifferentSessions1() throws Exception {
        this.testLockUseSameClientIdButDifferentSessions(false);
    }

    private void testLockUseSameClientIdButDifferentSessions(boolean isUnlock) throws Exception {
        String lockPath = "/test-lock-use-same-client-id-but-different-sessions-" + isUnlock + System.currentTimeMillis();
        String clientId = "test-lock-use-same-client-id-but-different-sessions";
        TestZKSessionLock.createLockPath(this.zkc.get(), lockPath);
        ZKSessionLock lock0 = new ZKSessionLock(this.zkc0, lockPath, clientId, this.lockStateExecutor);
        lock0.tryLock(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        ZKSessionLock lock1_0 = new ZKSessionLock(this.zkc, lockPath, clientId, this.lockStateExecutor);
        try {
            lock1_0.tryLock(0L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"Should fail locking since the lock is held in a different zk session.");
        }
        catch (OwnershipAcquireFailedException oafe) {
            Assert.assertEquals((Object)clientId, (Object)oafe.getCurrentOwner());
        }
        Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLOSED), (Object)((Object)lock1_0.getLockState()));
        List<String> children = TestZKSessionLock.getLockWaiters(this.zkc0, lockPath);
        Assert.assertEquals((long)1L, (long)children.size());
        Assert.assertEquals(lock0.getLockId(), Utils.ioResult(ZKSessionLock.asyncParseClientID(this.zkc0.get(), lockPath, children.get(0))));
        final ZKSessionLock lock1_1 = new ZKSessionLock(this.zkc, lockPath, clientId, this.lockStateExecutor);
        final CountDownLatch lock1DoneLatch = new CountDownLatch(1);
        Thread lock1Thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    lock1_1.tryLock(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                    lock1DoneLatch.countDown();
                }
                catch (LockingException e) {
                    logger.error("Failed on locking lock1 : ", (Throwable)e);
                }
            }
        }, "lock1-thread");
        lock1Thread.start();
        children = this.awaitWaiters(2, this.zkc, lockPath);
        logger.info("Found {} lock waiters : {}", (Object)children.size(), children);
        Assert.assertEquals((long)2L, (long)children.size());
        Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLAIMED), (Object)((Object)lock0.getLockState()));
        Assert.assertEquals(lock0.getLockId(), Utils.ioResult(ZKSessionLock.asyncParseClientID(this.zkc0.get(), lockPath, children.get(0))));
        this.awaitState(ZKSessionLock.State.WAITING, lock1_1);
        Assert.assertEquals(lock1_1.getLockId(), Utils.ioResult(ZKSessionLock.asyncParseClientID(this.zkc.get(), lockPath, children.get(1))));
        if (isUnlock) {
            lock0.unlock();
        } else {
            ZooKeeperClientUtils.expireSession(this.zkc0, zkServers, 2000);
        }
        lock1DoneLatch.await();
        lock1Thread.join();
        if (isUnlock) {
            Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLOSED), (Object)((Object)lock0.getLockState()));
        } else {
            Assert.assertEquals((Object)((Object)ZKSessionLock.State.EXPIRED), (Object)((Object)lock0.getLockState()));
        }
        Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLAIMED), (Object)((Object)lock1_1.getLockState()));
        children = TestZKSessionLock.getLockWaiters(this.zkc, lockPath);
        Assert.assertEquals((long)1L, (long)children.size());
        Assert.assertEquals(lock1_1.getLockId(), Utils.ioResult(ZKSessionLock.asyncParseClientID(this.zkc.get(), lockPath, children.get(0))));
        lock1_1.unlock();
    }

    @Test(timeout=60000L)
    public void testLockWithMultipleSiblingWaiters() throws Exception {
        String lockPath = "/test-lock-with-multiple-sibling-waiters";
        String clientId = "client-id";
        TestZKSessionLock.createLockPath(this.zkc.get(), lockPath);
        ZKSessionLock lock0 = new ZKSessionLock(this.zkc, lockPath, clientId, this.lockStateExecutor);
        ZKSessionLock lock1 = new ZKSessionLock(this.zkc, lockPath, clientId, this.lockStateExecutor);
        ZKSessionLock lock2 = new ZKSessionLock(this.zkc, lockPath, clientId, this.lockStateExecutor);
        lock0.tryLock(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        lock1.tryLock(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        lock2.tryLock(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        List<String> children = this.awaitWaiters(3, this.zkc, lockPath);
        Assert.assertEquals((long)3L, (long)children.size());
        Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLAIMED), (Object)((Object)lock0.getLockState()));
        Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLAIMED), (Object)((Object)lock1.getLockState()));
        Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLAIMED), (Object)((Object)lock2.getLockState()));
        lock0.unlock();
        lock1.unlock();
        lock2.unlock();
    }

    @Test(timeout=60000L)
    public void testLockWhenSiblingUseDifferentLockId0() throws Exception {
        this.testLockWhenSiblingUseDifferentLockId(0L, true);
    }

    @Test(timeout=60000L)
    public void testLockWhenSiblingUseDifferentLockId1() throws Exception {
        this.testLockWhenSiblingUseDifferentLockId(0L, false);
    }

    @Test(timeout=60000L)
    public void testLockWhenSiblingUseDifferentLockId2() throws Exception {
        this.testLockWhenSiblingUseDifferentLockId(Long.MAX_VALUE, true);
    }

    @Test(timeout=60000L)
    public void testLockWhenSiblingUseDifferentLockId3() throws Exception {
        this.testLockWhenSiblingUseDifferentLockId(Long.MAX_VALUE, false);
    }

    private void testLockWhenSiblingUseDifferentLockId(long timeout, final boolean isUnlock) throws Exception {
        String lockPath = "/test-lock-when-sibling-use-different-lock-id-" + timeout + "-" + isUnlock + "-" + System.currentTimeMillis();
        String clientId0 = "client-id-0";
        String clientId1 = "client-id-1";
        TestZKSessionLock.createLockPath(this.zkc.get(), lockPath);
        ZKSessionLock lock0_0 = new ZKSessionLock(this.zkc0, lockPath, clientId0, this.lockStateExecutor);
        final ZKSessionLock lock0_1 = new ZKSessionLock(this.zkc0, lockPath, clientId0, this.lockStateExecutor);
        final ZKSessionLock lock1 = new ZKSessionLock(this.zkc, lockPath, clientId1, this.lockStateExecutor);
        lock0_0.tryLock(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        final CountDownLatch lock1DoneLatch = new CountDownLatch(1);
        Thread lock1Thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    lock1.tryLock(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                    lock1DoneLatch.countDown();
                }
                catch (LockingException e) {
                    logger.error("Failed on locking lock1 : ", (Throwable)e);
                }
            }
        }, "lock1-thread");
        lock1Thread.start();
        List<String> children = this.awaitWaiters(2, this.zkc, lockPath);
        Assert.assertEquals((long)2L, (long)children.size());
        Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLAIMED), (Object)((Object)lock0_0.getLockState()));
        Assert.assertEquals(lock0_0.getLockId(), Utils.ioResult(ZKSessionLock.asyncParseClientID(this.zkc0.get(), lockPath, children.get(0))));
        this.awaitState(ZKSessionLock.State.WAITING, lock1);
        Assert.assertEquals(lock1.getLockId(), Utils.ioResult(ZKSessionLock.asyncParseClientID(this.zkc.get(), lockPath, children.get(1))));
        final CountDownLatch lock0DoneLatch = new CountDownLatch(1);
        final AtomicReference<Object> ownerFromLock0 = new AtomicReference<Object>(null);
        Thread lock0Thread = null;
        if (timeout == 0L) {
            try {
                lock0_1.tryLock(0L, TimeUnit.MILLISECONDS);
                Assert.fail((String)"Should fail on locking if sibling is using differnt lock id.");
            }
            catch (OwnershipAcquireFailedException oafe) {
                Assert.assertEquals((Object)clientId0, (Object)oafe.getCurrentOwner());
            }
            Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLOSED), (Object)((Object)lock0_1.getLockState()));
            children = TestZKSessionLock.getLockWaiters(this.zkc, lockPath);
            Assert.assertEquals((long)2L, (long)children.size());
            Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLAIMED), (Object)((Object)lock0_0.getLockState()));
            Assert.assertEquals(lock0_0.getLockId(), Utils.ioResult(ZKSessionLock.asyncParseClientID(this.zkc0.get(), lockPath, children.get(0))));
            Assert.assertEquals((Object)((Object)ZKSessionLock.State.WAITING), (Object)((Object)lock1.getLockState()));
            Assert.assertEquals(lock1.getLockId(), Utils.ioResult(ZKSessionLock.asyncParseClientID(this.zkc.get(), lockPath, children.get(1))));
        } else {
            lock0Thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        lock0_1.tryLock(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                        if (isUnlock) {
                            lock0DoneLatch.countDown();
                        }
                    }
                    catch (OwnershipAcquireFailedException oafe) {
                        if (!isUnlock) {
                            ownerFromLock0.set(oafe.getCurrentOwner());
                            lock0DoneLatch.countDown();
                        }
                    }
                    catch (LockingException le) {
                        logger.error("Failed on locking lock0_1 : ", (Throwable)le);
                    }
                }
            }, "lock0-thread");
            lock0Thread.start();
            children = this.awaitWaiters(3, this.zkc, lockPath);
            Assert.assertEquals((long)3L, (long)children.size());
            Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLAIMED), (Object)((Object)lock0_0.getLockState()));
            Assert.assertEquals(lock0_0.getLockId(), Utils.ioResult(ZKSessionLock.asyncParseClientID(this.zkc0.get(), lockPath, children.get(0))));
            this.awaitState(ZKSessionLock.State.WAITING, lock1);
            Assert.assertEquals(lock1.getLockId(), Utils.ioResult(ZKSessionLock.asyncParseClientID(this.zkc.get(), lockPath, children.get(1))));
            this.awaitState(ZKSessionLock.State.WAITING, lock0_1);
            Assert.assertEquals(lock0_1.getLockId(), Utils.ioResult(ZKSessionLock.asyncParseClientID(this.zkc0.get(), lockPath, children.get(2))));
        }
        if (isUnlock) {
            lock0_0.unlock();
        } else {
            ZooKeeperClientUtils.expireSession(this.zkc0, zkServers, 2000);
        }
        lock1DoneLatch.await();
        lock1Thread.join();
        if (isUnlock) {
            Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLOSED), (Object)((Object)lock0_0.getLockState()));
        } else {
            Assert.assertEquals((Object)((Object)ZKSessionLock.State.EXPIRED), (Object)((Object)lock0_0.getLockState()));
        }
        if (timeout == 0L) {
            children = TestZKSessionLock.getLockWaiters(this.zkc, lockPath);
            Assert.assertEquals((long)1L, (long)children.size());
            Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLAIMED), (Object)((Object)lock1.getLockState()));
            Assert.assertEquals(lock1.getLockId(), Utils.ioResult(ZKSessionLock.asyncParseClientID(this.zkc.get(), lockPath, children.get(0))));
        } else {
            Assert.assertNotNull((Object)lock0Thread);
            if (!isUnlock) {
                lock0DoneLatch.await();
                lock0Thread.join();
                Assert.assertEquals((Object)clientId0, ownerFromLock0.get());
                Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLOSED), (Object)((Object)lock0_1.getLockState()));
                children = TestZKSessionLock.getLockWaiters(this.zkc, lockPath);
                Assert.assertEquals((long)1L, (long)children.size());
                Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLAIMED), (Object)((Object)lock1.getLockState()));
                Assert.assertEquals(lock1.getLockId(), Utils.ioResult(ZKSessionLock.asyncParseClientID(this.zkc.get(), lockPath, children.get(0))));
            } else {
                children = TestZKSessionLock.getLockWaiters(this.zkc, lockPath);
                Assert.assertEquals((long)2L, (long)children.size());
                Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLAIMED), (Object)((Object)lock1.getLockState()));
                Assert.assertEquals(lock1.getLockId(), Utils.ioResult(ZKSessionLock.asyncParseClientID(this.zkc.get(), lockPath, children.get(0))));
                Assert.assertEquals((Object)((Object)ZKSessionLock.State.WAITING), (Object)((Object)lock0_1.getLockState()));
                Assert.assertEquals(lock0_1.getLockId(), Utils.ioResult(ZKSessionLock.asyncParseClientID(this.zkc0.get(), lockPath, children.get(1))));
            }
        }
        lock1.unlock();
        if (timeout != 0L && isUnlock) {
            lock0DoneLatch.await();
            lock0Thread.join();
            children = TestZKSessionLock.getLockWaiters(this.zkc, lockPath);
            Assert.assertEquals((long)1L, (long)children.size());
            Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLAIMED), (Object)((Object)lock0_1.getLockState()));
            Assert.assertEquals(lock0_1.getLockId(), Utils.ioResult(ZKSessionLock.asyncParseClientID(this.zkc0.get(), lockPath, children.get(0))));
        }
    }

    @Test(timeout=60000L)
    public void testLockWhenSiblingUseSameLockId0() throws Exception {
        this.testLockWhenSiblingUseSameLockId(0L, true);
    }

    @Test(timeout=60000L)
    public void testLockWhenSiblingUseSameLockId1() throws Exception {
        this.testLockWhenSiblingUseSameLockId(0L, false);
    }

    @Test(timeout=60000L)
    public void testLockWhenSiblingUseSameLockId2() throws Exception {
        this.testLockWhenSiblingUseSameLockId(Long.MAX_VALUE, true);
    }

    @Test(timeout=60000L)
    public void testLockWhenSiblingUseSameLockId3() throws Exception {
        this.testLockWhenSiblingUseSameLockId(Long.MAX_VALUE, false);
    }

    private void testLockWhenSiblingUseSameLockId(long timeout, boolean isUnlock) throws Exception {
        String lockPath = "/test-lock-when-sibling-use-same-lock-id-" + timeout + "-" + isUnlock + "-" + System.currentTimeMillis();
        String clientId = "client-id";
        TestZKSessionLock.createLockPath(this.zkc.get(), lockPath);
        ZKSessionLock lock0 = new ZKSessionLock(this.zkc0, lockPath, clientId, this.lockStateExecutor);
        ZKSessionLock lock1 = new ZKSessionLock(this.zkc0, lockPath, clientId, this.lockStateExecutor);
        lock0.tryLock(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        List<String> children = TestZKSessionLock.getLockWaiters(this.zkc0, lockPath);
        Assert.assertEquals((long)1L, (long)children.size());
        Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLAIMED), (Object)((Object)lock0.getLockState()));
        Assert.assertEquals(lock0.getLockId(), Utils.ioResult(ZKSessionLock.asyncParseClientID(this.zkc0.get(), lockPath, children.get(0))));
        lock1.tryLock(timeout, TimeUnit.MILLISECONDS);
        children = TestZKSessionLock.getLockWaiters(this.zkc0, lockPath);
        Assert.assertEquals((long)2L, (long)children.size());
        Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLAIMED), (Object)((Object)lock0.getLockState()));
        Assert.assertEquals(lock0.getLockId(), Utils.ioResult(ZKSessionLock.asyncParseClientID(this.zkc0.get(), lockPath, children.get(0))));
        Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLAIMED), (Object)((Object)lock1.getLockState()));
        Assert.assertEquals(lock1.getLockId(), Utils.ioResult(ZKSessionLock.asyncParseClientID(this.zkc0.get(), lockPath, children.get(1))));
        if (isUnlock) {
            lock0.unlock();
            Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLOSED), (Object)((Object)lock0.getLockState()));
            children = TestZKSessionLock.getLockWaiters(this.zkc0, lockPath);
            Assert.assertEquals((long)1L, (long)children.size());
            Assert.assertEquals((Object)((Object)ZKSessionLock.State.CLAIMED), (Object)((Object)lock1.getLockState()));
            Assert.assertEquals(lock1.getLockId(), Utils.ioResult(ZKSessionLock.asyncParseClientID(this.zkc0.get(), lockPath, children.get(0))));
            lock1.unlock();
        } else {
            ZooKeeperClientUtils.expireSession(this.zkc0, zkServers, 2000);
            CountDownLatch latch = new CountDownLatch(1);
            this.lockStateExecutor.executeOrdered(lockPath, () -> latch.countDown());
            latch.await();
            children = TestZKSessionLock.getLockWaiters(this.zkc, lockPath);
            Assert.assertEquals((long)0L, (long)children.size());
            Assert.assertEquals((Object)((Object)ZKSessionLock.State.EXPIRED), (Object)((Object)lock0.getLockState()));
            Assert.assertEquals((Object)((Object)ZKSessionLock.State.EXPIRED), (Object)((Object)lock1.getLockState()));
        }
    }

    class DelayFailpointAction
    extends FailpointUtils.AbstractFailPointAction {
        long timeout;

        DelayFailpointAction(long timeout) {
            this.timeout = timeout;
        }

        @Override
        public boolean checkFailPoint() throws IOException {
            try {
                Thread.sleep(this.timeout);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            return true;
        }
    }
}

