/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.net;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.pulsar.shade.org.apache.bookkeeper.net.DNSToSwitchMapping;
import org.apache.pulsar.shade.org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DNSResolver
implements DNSToSwitchMapping {
    static final Logger LOG = LoggerFactory.getLogger(DNSResolver.class);
    protected final ConcurrentMap<String, String> domainNameToNetworkLocation = new ConcurrentHashMap<String, String>();
    protected final ConcurrentMap<String, String> hostNameToRegion = new ConcurrentHashMap<String, String>();

    public DNSResolver() {
        this("");
    }

    public DNSResolver(String hostRegionOverrides) {
        if (StringUtils.isNotBlank(hostRegionOverrides)) {
            String[] overrides;
            for (String override : overrides = hostRegionOverrides.split(";")) {
                String[] parts = override.split(":");
                if (parts.length != 2) {
                    LOG.warn("Incorrect override specified : {}", (Object)override);
                    continue;
                }
                this.hostNameToRegion.putIfAbsent(parts[0], parts[1]);
            }
        }
    }

    @Override
    public List<String> resolve(List<String> names) {
        ArrayList<String> networkLocations = new ArrayList<String>(names.size());
        for (String name : names) {
            networkLocations.add(this.resolve(name));
        }
        return networkLocations;
    }

    private String resolve(String domainName) {
        String networkLocation = (String)this.domainNameToNetworkLocation.get(domainName);
        if (null == networkLocation) {
            networkLocation = this.resolveToNetworkLocation(domainName);
            this.domainNameToNetworkLocation.put(domainName, networkLocation);
        }
        return networkLocation;
    }

    protected abstract String resolveToNetworkLocation(String var1);

    @Override
    public void reloadCachedMappings() {
        this.domainNameToNetworkLocation.clear();
    }
}

