/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.zk;

import javax.annotation.Nullable;
import org.apache.distributedlog.util.Transaction;
import org.apache.distributedlog.zk.ZKOp;
import org.apache.pulsar.shade.org.apache.bookkeeper.versioning.LongVersion;
import org.apache.pulsar.shade.org.apache.bookkeeper.versioning.Version;
import org.apache.pulsar.shade.org.apache.zookeeper.KeeperException;
import org.apache.pulsar.shade.org.apache.zookeeper.Op;
import org.apache.pulsar.shade.org.apache.zookeeper.OpResult;

public class ZKVersionedSetOp
extends ZKOp {
    private final Transaction.OpListener<Version> listener;

    public ZKVersionedSetOp(Op op, @Nullable Transaction.OpListener<Version> opListener) {
        super(op);
        this.listener = opListener;
    }

    @Override
    protected void commitOpResult(OpResult opResult) {
        assert (opResult instanceof OpResult.SetDataResult);
        OpResult.SetDataResult setDataResult = (OpResult.SetDataResult)opResult;
        if (null != this.listener) {
            this.listener.onCommit(new LongVersion(setDataResult.getStat().getVersion()));
        }
    }

    @Override
    protected void abortOpResult(Throwable t, @Nullable OpResult opResult) {
        Throwable cause;
        if (null == opResult) {
            cause = t;
        } else {
            assert (opResult instanceof OpResult.ErrorResult);
            OpResult.ErrorResult errorResult = (OpResult.ErrorResult)opResult;
            cause = KeeperException.Code.OK.intValue() == errorResult.getErr() ? t : KeeperException.create(KeeperException.Code.get(errorResult.getErr()));
        }
        if (null != this.listener) {
            this.listener.onAbort(cause);
        }
    }
}

