/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats.metrics;

import java.util.List;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.stats.metrics.AbstractMetrics;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.apache.pulsar.shade.io.netty.buffer.PoolArenaMetric;
import org.apache.pulsar.shade.io.netty.buffer.PoolChunkListMetric;
import org.apache.pulsar.shade.io.netty.buffer.PoolChunkMetric;
import org.apache.pulsar.shade.io.netty.buffer.PooledByteBufAllocator;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.ManagedLedgerFactoryMXBean;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl.EntryCacheImpl;
import org.apache.pulsar.shade.org.apache.pulsar.common.stats.Metrics;

public class ManagedLedgerCacheMetrics
extends AbstractMetrics {
    private List<Metrics> metrics = Lists.newArrayList();

    public ManagedLedgerCacheMetrics(PulsarService pulsar) {
        super(pulsar);
    }

    @Override
    public synchronized List<Metrics> generate() {
        ManagedLedgerFactoryMXBean mlCacheStats = this.getManagedLedgerCacheStats();
        Metrics m = this.createMetrics();
        m.put("brk_ml_count", mlCacheStats.getNumberOfManagedLedgers());
        m.put("brk_ml_cache_used_size", mlCacheStats.getCacheUsedSize());
        m.put("brk_ml_cache_evictions", mlCacheStats.getNumberOfCacheEvictions());
        m.put("brk_ml_cache_hits_rate", mlCacheStats.getCacheHitsRate());
        m.put("brk_ml_cache_misses_rate", mlCacheStats.getCacheMissesRate());
        m.put("brk_ml_cache_hits_throughput", mlCacheStats.getCacheHitsThroughput());
        m.put("brk_ml_cache_misses_throughput", mlCacheStats.getCacheMissesThroughput());
        PooledByteBufAllocator allocator = EntryCacheImpl.ALLOCATOR;
        long activeAllocations = 0L;
        long activeAllocationsSmall = 0L;
        long activeAllocationsNormal = 0L;
        long activeAllocationsHuge = 0L;
        long totalAllocated = 0L;
        long totalUsed = 0L;
        for (PoolArenaMetric arena : allocator.metric().directArenas()) {
            activeAllocations += arena.numActiveAllocations();
            activeAllocationsSmall += arena.numActiveSmallAllocations();
            activeAllocationsNormal += arena.numActiveNormalAllocations();
            activeAllocationsHuge += arena.numActiveHugeAllocations();
            for (PoolChunkListMetric list : arena.chunkLists()) {
                for (PoolChunkMetric chunk : list) {
                    int size = chunk.chunkSize();
                    int used = size - chunk.freeBytes();
                    totalAllocated += (long)size;
                    totalUsed += (long)used;
                }
            }
        }
        m.put("brk_ml_cache_pool_allocated", totalAllocated);
        m.put("brk_ml_cache_pool_used", totalUsed);
        m.put("brk_ml_cache_pool_active_allocations", activeAllocations);
        m.put("brk_ml_cache_pool_active_allocations_small", activeAllocationsSmall);
        m.put("brk_ml_cache_pool_active_allocations_normal", activeAllocationsNormal);
        m.put("brk_ml_cache_pool_active_allocations_huge", activeAllocationsHuge);
        this.metrics.clear();
        this.metrics.add(m);
        return this.metrics;
    }
}

