/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.io.swagger.jackson;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import org.apache.pulsar.shade.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.pulsar.shade.com.fasterxml.jackson.core.Version;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.AnnotationIntrospector;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.introspect.Annotated;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.jsontype.NamedType;
import org.apache.pulsar.shade.io.swagger.annotations.ApiModel;
import org.apache.pulsar.shade.io.swagger.annotations.ApiModelProperty;
import org.apache.pulsar.shade.io.swagger.jackson.PackageVersion;

public class SwaggerAnnotationIntrospector
extends AnnotationIntrospector {
    private static final long serialVersionUID = 1L;
    private boolean isThereAHiddenField = false;

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public boolean hasIgnoreMarker(AnnotatedMember m) {
        ApiModelProperty ann = m.getAnnotation(ApiModelProperty.class);
        if (ann != null && ann.hidden()) {
            this.isThereAHiddenField = true;
            return true;
        }
        JsonCreator constructor = m.getAnnotation(JsonCreator.class);
        return constructor != null && this.isThereAHiddenField;
    }

    @Override
    public Boolean hasRequiredMarker(AnnotatedMember m) {
        ApiModelProperty ann = m.getAnnotation(ApiModelProperty.class);
        if (ann != null) {
            return ann.required();
        }
        XmlElement elem = m.getAnnotation(XmlElement.class);
        if (elem != null && elem.required()) {
            return true;
        }
        return null;
    }

    @Override
    public String findPropertyDescription(Annotated a) {
        ApiModel model = a.getAnnotation(ApiModel.class);
        if (model != null && !"".equals(model.description())) {
            return model.description();
        }
        ApiModelProperty prop = a.getAnnotation(ApiModelProperty.class);
        if (prop != null) {
            return prop.value();
        }
        return null;
    }

    @Override
    public Integer findPropertyIndex(Annotated a) {
        ApiModelProperty prop = a.getAnnotation(ApiModelProperty.class);
        if (prop != null && prop.position() != 0) {
            return prop.position();
        }
        return null;
    }

    @Override
    public List<NamedType> findSubtypes(Annotated a) {
        ApiModel api = a.getAnnotation(ApiModel.class);
        if (api != null) {
            Class<?>[] classes = api.subTypes();
            ArrayList<NamedType> names = new ArrayList<NamedType>(classes.length);
            for (Class<?> subType : classes) {
                names.add(new NamedType(subType));
            }
            if (!names.isEmpty()) {
                return names;
            }
        }
        return Collections.emptyList();
    }

    @Override
    public String findTypeName(AnnotatedClass ac) {
        return null;
    }
}

