/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.bookie;

import java.io.IOException;
import java.nio.channels.FileChannel;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.Unpooled;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.BufferedChannelBase;

public class BufferedReadChannel
extends BufferedChannelBase {
    protected final int readCapacity;
    protected final ByteBuf readBuffer;
    protected long readBufferStartPosition = Long.MIN_VALUE;
    long invocationCount = 0L;
    long cacheHitCount = 0L;

    public BufferedReadChannel(FileChannel fileChannel, int readCapacity) {
        super(fileChannel);
        this.readCapacity = readCapacity;
        this.readBuffer = Unpooled.buffer(readCapacity);
    }

    public int read(ByteBuf dest, long pos) throws IOException {
        return this.read(dest, pos, dest.writableBytes());
    }

    public synchronized int read(ByteBuf dest, long pos, int length) throws IOException {
        ++this.invocationCount;
        long currentPosition = pos;
        long eof = this.validateAndGetFileChannel().size();
        if (pos >= eof) {
            return -1;
        }
        while (length > 0) {
            if (this.readBufferStartPosition <= currentPosition && currentPosition < this.readBufferStartPosition + (long)this.readBuffer.readableBytes()) {
                int posInBuffer = (int)(currentPosition - this.readBufferStartPosition);
                int bytesToCopy = Math.min(length, this.readBuffer.readableBytes() - posInBuffer);
                dest.writeBytes(this.readBuffer, posInBuffer, bytesToCopy);
                currentPosition += (long)bytesToCopy;
                length -= bytesToCopy;
                ++this.cacheHitCount;
                continue;
            }
            if (currentPosition >= eof) break;
            this.readBufferStartPosition = currentPosition;
            int readBytes = 0;
            readBytes = this.validateAndGetFileChannel().read(this.readBuffer.internalNioBuffer(0, this.readCapacity), currentPosition);
            if (readBytes <= 0) {
                throw new IOException("Reading from filechannel returned a non-positive value. Short read.");
            }
            this.readBuffer.writerIndex(readBytes);
        }
        return (int)(currentPosition - pos);
    }

    public synchronized void clear() {
        this.readBuffer.clear();
    }
}

