/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.common.grpc.stats;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.MethodDescriptor;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.grpc.stats.ClientStats;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.grpc.stats.MonitoringClientCall;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.StatsLogger;

public class MonitoringClientInterceptor
implements ClientInterceptor {
    private final ClientStats.Factory statsFactory;
    private final StatsLogger statsLogger;
    private final ConcurrentMap<String, ClientStats> methods;

    public static MonitoringClientInterceptor create(StatsLogger statsLogger, boolean includeLatencyHistograms) {
        return new MonitoringClientInterceptor(new ClientStats.Factory(includeLatencyHistograms), statsLogger);
    }

    private MonitoringClientInterceptor(ClientStats.Factory statsFactory, StatsLogger statsLogger) {
        this.statsFactory = statsFactory;
        this.statsLogger = statsLogger;
        this.methods = new ConcurrentHashMap<String, ClientStats>();
    }

    private ClientStats getMethodStats(MethodDescriptor<?, ?> method) {
        ClientStats stats = (ClientStats)this.methods.get(method.getFullMethodName());
        if (null != stats) {
            return stats;
        }
        ClientStats newStats = this.statsFactory.createMetricsForMethod(method, this.statsLogger);
        ClientStats oldStats = this.methods.putIfAbsent(method.getFullMethodName(), newStats);
        if (null != oldStats) {
            return oldStats;
        }
        return newStats;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        ClientStats stats = this.getMethodStats(method);
        return new MonitoringClientCall(next.newCall(method, callOptions), stats);
    }
}

