/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.net;

import java.util.Objects;

public final class BookieId {
    private final String id;

    private BookieId(String id) {
        BookieId.validateBookieId(id);
        this.id = id;
    }

    public String toString() {
        return this.id;
    }

    public static BookieId parse(String serialized) {
        return new BookieId(serialized);
    }

    public String getId() {
        return this.id;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BookieId other = (BookieId)obj;
        return Objects.equals(this.id, other.id);
    }

    private static void validateBookieId(String id) {
        Objects.requireNonNull(id, "BookieId cannot be null");
        if (!id.matches("[a-zA-Z0-9:-_.\\-]+") || "readonly".equalsIgnoreCase(id)) {
            throw new IllegalArgumentException("BookieId " + id + " is not valid");
        }
    }
}

