/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.proto;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.shade.com.google.protobuf.ByteString;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.channel.Channel;
import org.apache.pulsar.shade.io.netty.util.ReferenceCountUtil;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.Bookie;
import org.apache.pulsar.shade.org.apache.bookkeeper.proto.BookieRequestProcessor;
import org.apache.pulsar.shade.org.apache.bookkeeper.proto.BookkeeperProtocol;
import org.apache.pulsar.shade.org.apache.bookkeeper.proto.PacketProcessorBaseV3;
import org.apache.pulsar.shade.org.apache.bookkeeper.util.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReadLacProcessorV3
extends PacketProcessorBaseV3
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ReadLacProcessorV3.class);

    public ReadLacProcessorV3(BookkeeperProtocol.Request request, Channel channel, BookieRequestProcessor requestProcessor) {
        super(request, channel, requestProcessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private BookkeeperProtocol.ReadLacResponse getReadLacResponse() {
        ByteBuf lac;
        ByteBuf lastEntry;
        BookkeeperProtocol.StatusCode status;
        BookkeeperProtocol.ReadLacResponse.Builder readLacResponse;
        long startTimeNanos;
        block17: {
            long ledgerId;
            block16: {
                startTimeNanos = MathUtils.nowInNano();
                BookkeeperProtocol.ReadLacRequest readLacRequest = this.request.getReadLacRequest();
                ledgerId = readLacRequest.getLedgerId();
                readLacResponse = BookkeeperProtocol.ReadLacResponse.newBuilder().setLedgerId(ledgerId);
                if (!this.isVersionCompatible()) {
                    readLacResponse.setStatus(BookkeeperProtocol.StatusCode.EBADVERSION);
                    return readLacResponse.build();
                }
                logger.debug("Received ReadLac request: {}", (Object)this.request);
                status = BookkeeperProtocol.StatusCode.EOK;
                lastEntry = null;
                lac = null;
                try {
                    lac = this.requestProcessor.bookie.getExplicitLac(ledgerId);
                    if (lac == null) break block16;
                    readLacResponse.setLacBody(ByteString.copyFrom(lac.nioBuffer()));
                }
                catch (Bookie.NoLedgerException e) {
                    status = BookkeeperProtocol.StatusCode.ENOLEDGER;
                    logger.error("No ledger found while performing readLac from ledger: {}", (Object)ledgerId, (Object)e);
                    ReferenceCountUtil.release(lac);
                }
                catch (IOException e2) {
                    status = BookkeeperProtocol.StatusCode.EIO;
                    logger.error("IOException while performing readLac from ledger: {}", (Object)ledgerId);
                    {
                        catch (Throwable throwable) {
                            ReferenceCountUtil.release(lac);
                            throw throwable;
                        }
                    }
                    ReferenceCountUtil.release(lac);
                }
            }
            ReferenceCountUtil.release(lac);
            try {
                lastEntry = this.requestProcessor.bookie.readEntry(ledgerId, -1L);
                if (lastEntry == null) break block17;
                readLacResponse.setLastEntryBody(ByteString.copyFrom(lastEntry.nioBuffer()));
            }
            catch (Bookie.NoLedgerException e) {
                status = BookkeeperProtocol.StatusCode.ENOLEDGER;
                logger.error("No ledger found while trying to read last entry: {}", (Object)ledgerId, (Object)e);
                ReferenceCountUtil.release(lastEntry);
            }
            catch (IOException e3) {
                status = BookkeeperProtocol.StatusCode.EIO;
                logger.error("IOException while trying to read last entry: {}", (Object)ledgerId, (Object)e3);
                {
                    catch (Throwable throwable) {
                        ReferenceCountUtil.release(lastEntry);
                        throw throwable;
                    }
                }
                ReferenceCountUtil.release(lastEntry);
            }
        }
        ReferenceCountUtil.release(lastEntry);
        if (lac == null && lastEntry == null) {
            status = BookkeeperProtocol.StatusCode.ENOENTRY;
        }
        if (status == BookkeeperProtocol.StatusCode.EOK) {
            this.requestProcessor.getRequestStats().getReadLacStats().registerSuccessfulEvent(MathUtils.elapsedNanos(startTimeNanos), TimeUnit.NANOSECONDS);
        } else {
            this.requestProcessor.getRequestStats().getReadLacStats().registerFailedEvent(MathUtils.elapsedNanos(startTimeNanos), TimeUnit.NANOSECONDS);
        }
        readLacResponse.setStatus(status);
        return readLacResponse.build();
    }

    @Override
    public void safeRun() {
        BookkeeperProtocol.ReadLacResponse readLacResponse = this.getReadLacResponse();
        this.sendResponse(readLacResponse);
    }

    private void sendResponse(BookkeeperProtocol.ReadLacResponse readLacResponse) {
        BookkeeperProtocol.Response.Builder response = BookkeeperProtocol.Response.newBuilder().setHeader(this.getHeader()).setStatus(readLacResponse.getStatus()).setReadLacResponse(readLacResponse);
        this.sendResponse(response.getStatus(), response.build(), this.requestProcessor.getRequestStats().getReadLacRequestStats());
    }
}

