/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.intercept;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import org.apache.pulsar.shade.org.apache.pulsar.common.intercept.BrokerEntryMetadataInterceptor;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.ClassLoaderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerEntryMetadataUtils {
    private static final Logger log = LoggerFactory.getLogger(BrokerEntryMetadataUtils.class);

    public static Set<BrokerEntryMetadataInterceptor> loadBrokerEntryMetadataInterceptors(Set<String> interceptorNames, ClassLoader classLoader) {
        HashSet<BrokerEntryMetadataInterceptor> interceptors = new HashSet<BrokerEntryMetadataInterceptor>();
        if (interceptorNames != null && interceptorNames.size() > 0) {
            for (String interceptorName : interceptorNames) {
                try {
                    Class<?> clz = ClassLoaderUtils.loadClass(interceptorName, classLoader);
                    try {
                        interceptors.add((BrokerEntryMetadataInterceptor)clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        log.error("Create new BrokerEntryMetadataInterceptor instance for {} failed.", (Object)interceptorName, (Object)e);
                        throw new RuntimeException(e);
                    }
                }
                catch (ClassNotFoundException e) {
                    log.error("Load BrokerEntryMetadataInterceptor class for {} failed.", (Object)interceptorName, (Object)e);
                    throw new RuntimeException(e);
                }
            }
        }
        return interceptors;
    }
}

