/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.intercept;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.LedgerHandle;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.api.LedgerEntry;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl.OpAddEntry;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.intercept.ManagedLedgerInterceptor;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.BrokerEntryMetadata;
import org.apache.pulsar.shade.org.apache.pulsar.common.intercept.AppendIndexMetadataInterceptor;
import org.apache.pulsar.shade.org.apache.pulsar.common.intercept.BrokerEntryMetadataInterceptor;
import org.apache.pulsar.shade.org.apache.pulsar.common.protocol.Commands;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedLedgerInterceptorImpl
implements ManagedLedgerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ManagedLedgerInterceptorImpl.class);
    private static final String INDEX = "index";
    private final Set<BrokerEntryMetadataInterceptor> brokerEntryMetadataInterceptors;

    public ManagedLedgerInterceptorImpl(Set<BrokerEntryMetadataInterceptor> brokerEntryMetadataInterceptors) {
        this.brokerEntryMetadataInterceptors = brokerEntryMetadataInterceptors;
    }

    public long getIndex() {
        long index = -1L;
        for (BrokerEntryMetadataInterceptor interceptor : this.brokerEntryMetadataInterceptors) {
            if (!(interceptor instanceof AppendIndexMetadataInterceptor)) continue;
            index = ((AppendIndexMetadataInterceptor)interceptor).getIndex();
        }
        return index;
    }

    @Override
    public OpAddEntry beforeAddEntry(OpAddEntry op, int numberOfMessages) {
        if (op == null || numberOfMessages <= 0) {
            return op;
        }
        op.setData(Commands.addBrokerEntryMetadata(op.getData(), this.brokerEntryMetadataInterceptors, numberOfMessages));
        return op;
    }

    @Override
    public void onManagedLedgerPropertiesInitialize(Map<String, String> propertiesMap) {
        if (propertiesMap == null || propertiesMap.size() == 0) {
            return;
        }
        if (propertiesMap.containsKey(INDEX)) {
            for (BrokerEntryMetadataInterceptor interceptor : this.brokerEntryMetadataInterceptors) {
                if (!(interceptor instanceof AppendIndexMetadataInterceptor)) continue;
                ((AppendIndexMetadataInterceptor)interceptor).recoveryIndexGenerator(Long.parseLong(propertiesMap.get(INDEX)));
            }
        }
    }

    @Override
    public CompletableFuture<Void> onManagedLedgerLastLedgerInitialize(String name, LedgerHandle lh) {
        CompletableFuture<Void> promise = new CompletableFuture<Void>();
        boolean hasAppendIndexMetadataInterceptor = this.brokerEntryMetadataInterceptors.stream().anyMatch(interceptor -> interceptor instanceof AppendIndexMetadataInterceptor);
        if (hasAppendIndexMetadataInterceptor && lh.getLastAddConfirmed() >= 0L) {
            lh.readAsync(lh.getLastAddConfirmed(), lh.getLastAddConfirmed()).whenComplete((entries, ex) -> {
                if (ex != null) {
                    log.error("[{}] Read last entry error.", (Object)name, ex);
                    promise.completeExceptionally((Throwable)ex);
                } else if (entries != null) {
                    try {
                        LedgerEntry ledgerEntry = entries.getEntry(lh.getLastAddConfirmed());
                        if (ledgerEntry != null) {
                            BrokerEntryMetadata brokerEntryMetadata = Commands.parseBrokerEntryMetadataIfExist(ledgerEntry.getEntryBuffer());
                            for (BrokerEntryMetadataInterceptor interceptor : this.brokerEntryMetadataInterceptors) {
                                if (!(interceptor instanceof AppendIndexMetadataInterceptor) || brokerEntryMetadata == null || !brokerEntryMetadata.hasIndex()) continue;
                                ((AppendIndexMetadataInterceptor)interceptor).recoveryIndexGenerator(brokerEntryMetadata.getIndex());
                            }
                        }
                        entries.close();
                        promise.complete(null);
                    }
                    catch (Exception e) {
                        entries.close();
                        log.error("[{}] Failed to recover the index generator from the last add confirmed entry.", (Object)name, (Object)e);
                        promise.completeExceptionally(e);
                    }
                } else {
                    promise.complete(null);
                }
            });
        } else {
            promise.complete(null);
        }
        return promise;
    }

    @Override
    public void onUpdateManagedLedgerInfo(Map<String, String> propertiesMap) {
        for (BrokerEntryMetadataInterceptor interceptor : this.brokerEntryMetadataInterceptors) {
            if (!(interceptor instanceof AppendIndexMetadataInterceptor)) continue;
            propertiesMap.put(INDEX, String.valueOf(((AppendIndexMetadataInterceptor)interceptor).getIndex()));
        }
    }
}

