/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.resources;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.pulsar.broker.resources.BaseResources;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.ResourceGroup;

public class ResourceGroupResources
extends BaseResources<ResourceGroup> {
    private static final String BASE_PATH = "/admin/resourcegroups";

    public ResourceGroupResources(MetadataStore store, int operationTimeoutSec) {
        super(store, ResourceGroup.class, operationTimeoutSec);
    }

    public Optional<ResourceGroup> getResourceGroup(String resourceGroupName) throws MetadataStoreException {
        return this.get(ResourceGroupResources.joinPath(BASE_PATH, resourceGroupName));
    }

    public CompletableFuture<Optional<ResourceGroup>> getResourceGroupAsync(String resourceGroupName) {
        return this.getAsync(ResourceGroupResources.joinPath(BASE_PATH, resourceGroupName));
    }

    public boolean resourceGroupExists(String resourceGroupName) throws MetadataStoreException {
        return this.exists(ResourceGroupResources.joinPath(BASE_PATH, resourceGroupName));
    }

    public void createResourceGroup(String resourceGroupName, ResourceGroup rg) throws MetadataStoreException {
        this.create(ResourceGroupResources.joinPath(BASE_PATH, resourceGroupName), rg);
    }

    public void deleteResourceGroup(String resourceGroupName) throws MetadataStoreException {
        this.delete(ResourceGroupResources.joinPath(BASE_PATH, resourceGroupName));
    }

    public void updateResourceGroup(String resourceGroupName, Function<ResourceGroup, ResourceGroup> modifyFunction) throws MetadataStoreException {
        this.set(ResourceGroupResources.joinPath(BASE_PATH, resourceGroupName), modifyFunction);
    }

    public List<String> listResourceGroups() throws MetadataStoreException {
        return this.getChildren(BASE_PATH);
    }

    public CompletableFuture<List<String>> listResourceGroupsAsync() {
        return this.getChildrenAsync(BASE_PATH);
    }

    public static boolean isResourceGroupPath(String path) {
        return path.startsWith(BASE_PATH);
    }

    public static Optional<String> resourceGroupNameFromPath(String path) {
        if (path.length() > BASE_PATH.length() + 1) {
            return Optional.of(path.substring(BASE_PATH.length() + 1));
        }
        return Optional.empty();
    }
}

