/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.concurrent.atomic.LongAdder;
import org.apache.pulsar.broker.service.PublishRateLimiter;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.PublishRate;

public class PublishRateLimiterImpl
implements PublishRateLimiter {
    protected volatile int publishMaxMessageRate = 0;
    protected volatile long publishMaxByteRate = 0L;
    protected volatile boolean publishThrottlingEnabled = false;
    protected volatile boolean publishRateExceeded = false;
    protected volatile LongAdder currentPublishMsgCount = new LongAdder();
    protected volatile LongAdder currentPublishByteCount = new LongAdder();

    public PublishRateLimiterImpl(Policies policies, String clusterName) {
        this.update(policies, clusterName);
    }

    public PublishRateLimiterImpl(PublishRate maxPublishRate) {
        this.update(maxPublishRate);
    }

    @Override
    public void checkPublishRate() {
        if (this.publishThrottlingEnabled && !this.publishRateExceeded) {
            long currentPublishMsgRate;
            long currentPublishByteRate;
            if (this.publishMaxByteRate > 0L && (currentPublishByteRate = this.currentPublishByteCount.sum()) > this.publishMaxByteRate) {
                this.publishRateExceeded = true;
                return;
            }
            if (this.publishMaxMessageRate > 0 && (currentPublishMsgRate = this.currentPublishMsgCount.sum()) > (long)this.publishMaxMessageRate) {
                this.publishRateExceeded = true;
            }
        }
    }

    @Override
    public void incrementPublishCount(int numOfMessages, long msgSizeInBytes) {
        if (this.publishThrottlingEnabled) {
            this.currentPublishMsgCount.add(numOfMessages);
            this.currentPublishByteCount.add(msgSizeInBytes);
        }
    }

    @Override
    public boolean resetPublishCount() {
        if (this.publishThrottlingEnabled) {
            this.currentPublishMsgCount.reset();
            this.currentPublishByteCount.reset();
            this.publishRateExceeded = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean isPublishRateExceeded() {
        return this.publishRateExceeded;
    }

    @Override
    public void update(Policies policies, String clusterName) {
        PublishRate maxPublishRate = policies.publishMaxMessageRate != null ? policies.publishMaxMessageRate.get(clusterName) : null;
        this.update(maxPublishRate);
    }

    @Override
    public void update(PublishRate maxPublishRate) {
        if (maxPublishRate != null && (maxPublishRate.publishThrottlingRateInMsg > 0 || maxPublishRate.publishThrottlingRateInByte > 0L)) {
            this.publishThrottlingEnabled = true;
            this.publishMaxMessageRate = Math.max(maxPublishRate.publishThrottlingRateInMsg, 0);
            this.publishMaxByteRate = Math.max(maxPublishRate.publishThrottlingRateInByte, 0L);
        } else {
            this.publishMaxMessageRate = 0;
            this.publishMaxByteRate = 0L;
            this.publishThrottlingEnabled = false;
        }
        this.resetPublishCount();
    }

    @Override
    public boolean tryAcquire(int numbers, long bytes) {
        return false;
    }

    @Override
    public void close() throws Exception {
    }
}

