/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.persistent;

import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.pulsar.shade.com.google.common.collect.ComparisonChain;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.pulsar.shade.org.apache.bookkeeper.util.collections.ConcurrentLongLongPairHashMap;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.collections.ConcurrentSortedLongPairSet;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.collections.LongPairSet;

public class MessageRedeliveryController {
    private final LongPairSet messagesToRedeliver = new ConcurrentSortedLongPairSet(128, 2);
    private final ConcurrentLongLongPairHashMap hashesToBeBlocked;

    public MessageRedeliveryController(boolean allowOutOfOrderDelivery) {
        this.hashesToBeBlocked = allowOutOfOrderDelivery ? null : new ConcurrentLongLongPairHashMap(128, 2);
    }

    public boolean add(long ledgerId, long entryId) {
        return this.messagesToRedeliver.add(ledgerId, entryId);
    }

    public boolean add(long ledgerId, long entryId, long stickyKeyHash) {
        if (this.hashesToBeBlocked != null) {
            this.hashesToBeBlocked.put(ledgerId, entryId, stickyKeyHash, 0L);
        }
        return this.messagesToRedeliver.add(ledgerId, entryId);
    }

    public boolean remove(long ledgerId, long entryId) {
        if (this.hashesToBeBlocked != null) {
            this.hashesToBeBlocked.remove(ledgerId, entryId);
        }
        return this.messagesToRedeliver.remove(ledgerId, entryId);
    }

    public int removeAllUpTo(long markDeleteLedgerId, long markDeleteEntryId) {
        if (this.hashesToBeBlocked != null) {
            ArrayList keysToRemove = new ArrayList();
            this.hashesToBeBlocked.forEach((ledgerId, entryId, stickyKeyHash, none) -> {
                if (ComparisonChain.start().compare(ledgerId, markDeleteLedgerId).compare(entryId, markDeleteEntryId).result() <= 0) {
                    keysToRemove.add(new ConcurrentLongLongPairHashMap.LongPair(ledgerId, entryId));
                }
            });
            keysToRemove.forEach(longPair -> this.hashesToBeBlocked.remove(longPair.first, longPair.second));
            keysToRemove.clear();
        }
        return this.messagesToRedeliver.removeIf((ledgerId, entryId) -> ComparisonChain.start().compare(ledgerId, markDeleteLedgerId).compare(entryId, markDeleteEntryId).result() <= 0);
    }

    public boolean isEmpty() {
        return this.messagesToRedeliver.isEmpty();
    }

    public void clear() {
        if (this.hashesToBeBlocked != null) {
            this.hashesToBeBlocked.clear();
        }
        this.messagesToRedeliver.clear();
    }

    public String toString() {
        return this.messagesToRedeliver.toString();
    }

    public boolean containsStickyKeyHashes(Set<Integer> stickyKeyHashes) {
        AtomicBoolean isContained = new AtomicBoolean(false);
        if (this.hashesToBeBlocked != null) {
            this.hashesToBeBlocked.forEach((ledgerId, entryId, stickyKeyHash, none) -> {
                if (!isContained.get() && stickyKeyHashes.contains((int)stickyKeyHash)) {
                    isContained.set(true);
                }
            });
        }
        return isContained.get();
    }

    public Set<PositionImpl> getMessagesToReplayNow(int maxMessagesToRead) {
        if (this.hashesToBeBlocked != null) {
            return this.messagesToRedeliver.items().stream().sorted((l1, l2) -> ComparisonChain.start().compare(l1.first, l2.first).compare(l1.second, l2.second).result()).limit(maxMessagesToRead).map(longPair -> new PositionImpl(longPair.first, longPair.second)).collect(Collectors.toCollection(TreeSet::new));
        }
        return this.messagesToRedeliver.items(maxMessagesToRead, (ledgerId, entryId) -> new PositionImpl(ledgerId, entryId));
    }
}

