/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.auth.oauth2;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.pulsar.client.api.AuthenticationDataProvider;

class AuthenticationDataOAuth2
implements AuthenticationDataProvider {
    public static final String HTTP_HEADER_NAME = "Authorization";
    private final String accessToken;
    private final Set<Map.Entry<String, String>> headers;

    public AuthenticationDataOAuth2(String accessToken) {
        this.accessToken = accessToken;
        this.headers = Collections.singletonMap(HTTP_HEADER_NAME, "Bearer " + accessToken).entrySet();
    }

    @Override
    public boolean hasDataForHttp() {
        return true;
    }

    @Override
    public Set<Map.Entry<String, String>> getHttpHeaders() {
        return this.headers;
    }

    @Override
    public boolean hasDataFromCommand() {
        return true;
    }

    @Override
    public String getCommandData() {
        return this.accessToken;
    }
}

