/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.nio.ByteBuffer;
import org.apache.pulsar.client.impl.schema.AbstractSchema;
import org.apache.pulsar.client.impl.schema.SchemaInfoImpl;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.shade.org.apache.pulsar.common.schema.SchemaType;

public class ByteBufferSchema
extends AbstractSchema<ByteBuffer> {
    private static final ByteBufferSchema INSTANCE;
    private static final SchemaInfo SCHEMA_INFO;

    public static ByteBufferSchema of() {
        return INSTANCE;
    }

    @Override
    public byte[] encode(ByteBuffer data) {
        if (data == null) {
            return null;
        }
        data.rewind();
        if (data.hasArray()) {
            byte[] arr = data.array();
            if (data.arrayOffset() == 0 && arr.length == data.remaining()) {
                return arr;
            }
        }
        byte[] ret = new byte[data.remaining()];
        data.get(ret, 0, ret.length);
        data.rewind();
        return ret;
    }

    @Override
    public ByteBuffer decode(byte[] data) {
        if (null == data) {
            return null;
        }
        return ByteBuffer.wrap(data);
    }

    @Override
    public ByteBuffer decode(ByteBuf byteBuffer) {
        if (null == byteBuffer) {
            return null;
        }
        int size = byteBuffer.readableBytes();
        byte[] bytes = new byte[size];
        byteBuffer.readBytes(bytes);
        return ByteBuffer.wrap(bytes);
    }

    @Override
    public ByteBuffer decode(ByteBuffer byteBuffer, byte[] schemaVersion) {
        return byteBuffer;
    }

    @Override
    public SchemaInfo getSchemaInfo() {
        return SCHEMA_INFO;
    }

    static {
        SCHEMA_INFO = new SchemaInfoImpl().setName("ByteBuffer").setType(SchemaType.BYTES).setSchema(new byte[0]);
        INSTANCE = new ByteBufferSchema();
    }
}

