/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema.generic;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.api.schema.Field;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.client.api.schema.SchemaReader;
import org.apache.pulsar.client.impl.schema.generic.GenericJsonRecord;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.JsonNode;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.pulsar.shade.org.apache.pulsar.common.schema.SchemaInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericJsonReader
implements SchemaReader<GenericRecord> {
    private final ObjectMapper objectMapper;
    private final byte[] schemaVersion;
    private final List<Field> fields;
    private SchemaInfo schemaInfo;
    private static final Logger log = LoggerFactory.getLogger(GenericJsonReader.class);

    public GenericJsonReader(List<Field> fields, SchemaInfo schemaInfo) {
        this.fields = fields;
        this.schemaVersion = null;
        this.objectMapper = new ObjectMapper();
        this.schemaInfo = schemaInfo;
    }

    public GenericJsonReader(List<Field> fields) {
        this(fields, null);
    }

    public GenericJsonReader(byte[] schemaVersion, List<Field> fields) {
        this(schemaVersion, fields, null);
    }

    public GenericJsonReader(byte[] schemaVersion, List<Field> fields, SchemaInfo schemaInfo) {
        this.objectMapper = new ObjectMapper();
        this.fields = fields;
        this.schemaVersion = schemaVersion;
        this.schemaInfo = schemaInfo;
    }

    @Override
    public GenericJsonRecord read(byte[] bytes, int offset, int length) {
        try {
            JsonNode jn = this.objectMapper.readTree(new String(bytes, offset, length, StandardCharsets.UTF_8));
            return new GenericJsonRecord(this.schemaVersion, this.fields, jn, this.schemaInfo);
        }
        catch (IOException ioe) {
            throw new SchemaSerializationException(ioe);
        }
    }

    @Override
    public GenericRecord read(InputStream inputStream) {
        try {
            JsonNode jn = this.objectMapper.readTree(inputStream);
            GenericJsonRecord genericJsonRecord = new GenericJsonRecord(this.schemaVersion, this.fields, jn, this.schemaInfo);
            return genericJsonRecord;
        }
        catch (IOException ioe) {
            throw new SchemaSerializationException(ioe);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                log.error("GenericJsonReader close inputStream close error", (Throwable)e);
            }
        }
    }
}

