/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.util;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.apache.pulsar.shade.io.netty.util.concurrent.DefaultThreadFactory;
import org.apache.pulsar.shade.org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.Murmur3_32Hash;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorProvider {
    private static final Logger log = LoggerFactory.getLogger(ExecutorProvider.class);
    private final int numThreads;
    private final List<Pair<ExecutorService, ExtendedThreadFactory>> executors;
    private final AtomicInteger currentThread = new AtomicInteger(0);
    private final String poolName;
    private volatile boolean isShutdown;

    public ExecutorProvider(int numThreads, String poolName) {
        Preconditions.checkArgument(numThreads > 0);
        this.numThreads = numThreads;
        Preconditions.checkNotNull(poolName);
        this.executors = Lists.newArrayListWithCapacity(numThreads);
        for (int i = 0; i < numThreads; ++i) {
            ExtendedThreadFactory threadFactory = new ExtendedThreadFactory(poolName, Thread.currentThread().isDaemon());
            ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(threadFactory);
            this.executors.add(Pair.of(executor, threadFactory));
        }
        this.isShutdown = false;
        this.poolName = poolName;
    }

    public ExecutorService getExecutor() {
        return this.executors.get((this.currentThread.getAndIncrement() & Integer.MAX_VALUE) % this.numThreads).getKey();
    }

    public ExecutorService getExecutor(Object object) {
        return this.getExecutorInternal(object == null ? -1 : object.hashCode() & Integer.MAX_VALUE);
    }

    public ExecutorService getExecutor(byte[] bytes) {
        int keyHash = Murmur3_32Hash.getInstance().makeHash(bytes);
        return this.getExecutorInternal(keyHash);
    }

    private ExecutorService getExecutorInternal(int hash) {
        return this.executors.get((hash & Integer.MAX_VALUE) % this.numThreads).getKey();
    }

    public void shutdownNow() {
        this.executors.forEach(entry -> {
            ExecutorService executor = (ExecutorService)entry.getKey();
            ExtendedThreadFactory threadFactory = (ExtendedThreadFactory)entry.getValue();
            executor.shutdownNow();
            try {
                if (!executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                    log.warn("Failed to terminate executor with pool name {} within timeout. The following are stack traces of still running threads.\n{}", (Object)this.poolName, (Object)this.getThreadDump(threadFactory.getThread()));
                }
            }
            catch (InterruptedException e) {
                log.warn("Shutdown of thread pool was interrupted");
            }
        });
        this.isShutdown = true;
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    private String getThreadDump(Thread thread) {
        StringBuilder dump = new StringBuilder();
        dump.append('\n');
        dump.append(String.format("\"%s\" %s prio=%d tid=%d %s%njava.lang.Thread.State: %s", thread.getName(), thread.isDaemon() ? "daemon" : "", thread.getPriority(), thread.getId(), Thread.State.WAITING.equals((Object)thread.getState()) ? "in Object.wait()" : thread.getState().name(), Thread.State.WAITING.equals((Object)thread.getState()) ? "WAITING (on object monitor)" : thread.getState()));
        for (StackTraceElement stackTraceElement : thread.getStackTrace()) {
            dump.append("\n        at ");
            dump.append(stackTraceElement);
        }
        dump.append("\n");
        return dump.toString();
    }

    private static class ExtendedThreadFactory
    extends DefaultThreadFactory {
        private Thread thread;

        public ExtendedThreadFactory(String poolName, boolean daemon) {
            super(poolName, daemon);
        }

        @Override
        public Thread newThread(Runnable r) {
            this.thread = super.newThread(r);
            return this.thread;
        }

        public Thread getThread() {
            return this.thread;
        }
    }
}

