/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.compaction;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.RawReader;
import org.apache.pulsar.compaction.CompactorMXBean;
import org.apache.pulsar.compaction.CompactorMXBeanImpl;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.BookKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Compactor {
    private static final Logger log = LoggerFactory.getLogger(Compactor.class);
    public static final String COMPACTION_SUBSCRIPTION = "__compaction";
    public static final String COMPACTED_TOPIC_LEDGER_PROPERTY = "CompactedTopicLedger";
    static final BookKeeper.DigestType COMPACTED_TOPIC_LEDGER_DIGEST_TYPE = BookKeeper.DigestType.CRC32;
    static final byte[] COMPACTED_TOPIC_LEDGER_PASSWORD = "".getBytes(StandardCharsets.UTF_8);
    protected final ServiceConfiguration conf;
    protected final ScheduledExecutorService scheduler;
    private final PulsarClient pulsar;
    private final BookKeeper bk;
    protected final CompactorMXBeanImpl mxBean;

    public Compactor(ServiceConfiguration conf, PulsarClient pulsar, BookKeeper bk, ScheduledExecutorService scheduler) {
        this.conf = conf;
        this.scheduler = scheduler;
        this.pulsar = pulsar;
        this.bk = bk;
        this.mxBean = new CompactorMXBeanImpl();
    }

    public CompletableFuture<Long> compact(String topic) {
        return RawReader.create(this.pulsar, topic, COMPACTION_SUBSCRIPTION).thenComposeAsync(this::compactAndCloseReader, (Executor)this.scheduler);
    }

    private CompletableFuture<Long> compactAndCloseReader(RawReader reader) {
        CompletableFuture<Long> promise = new CompletableFuture<Long>();
        this.mxBean.addCompactionStartOp(reader.getTopic());
        this.doCompaction(reader, this.bk).whenComplete((ledgerId, exception) -> reader.closeAsync().whenComplete((v, exception2) -> {
            if (exception2 != null) {
                log.warn("Error closing reader handle {}, ignoring", (Object)reader, exception2);
            }
            if (exception != null) {
                this.mxBean.addCompactionEndOp(reader.getTopic(), false);
                promise.completeExceptionally((Throwable)exception);
            } else {
                this.mxBean.addCompactionEndOp(reader.getTopic(), true);
                promise.complete((Long)ledgerId);
            }
        }));
        return promise;
    }

    protected abstract CompletableFuture<Long> doCompaction(RawReader var1, BookKeeper var2);

    public CompactorMXBean getStats() {
        return this.mxBean;
    }
}

