/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.utils;

import org.apache.pulsar.shade.org.apache.pulsar.common.functions.WindowConfig;

public class WindowConfigUtils {
    public static final long DEFAULT_MAX_LAG_MS = 0L;
    public static final long DEFAULT_WATERMARK_EVENT_INTERVAL_MS = 1000L;

    public static void validate(WindowConfig windowConfig) {
        if (windowConfig.getWindowLengthDurationMs() == null && windowConfig.getWindowLengthCount() == null) {
            throw new IllegalArgumentException("Window length is not specified");
        }
        if (windowConfig.getWindowLengthDurationMs() != null && windowConfig.getWindowLengthCount() != null) {
            throw new IllegalArgumentException("Window length for time and count are set! Please set one or the other.");
        }
        if (windowConfig.getWindowLengthCount() != null && windowConfig.getWindowLengthCount() <= 0) {
            throw new IllegalArgumentException("Window length must be positive [" + windowConfig.getWindowLengthCount() + "]");
        }
        if (windowConfig.getWindowLengthDurationMs() != null && windowConfig.getWindowLengthDurationMs() <= 0L) {
            throw new IllegalArgumentException("Window length must be positive [" + windowConfig.getWindowLengthDurationMs() + "]");
        }
        if (windowConfig.getSlidingIntervalCount() != null && windowConfig.getSlidingIntervalCount() <= 0) {
            throw new IllegalArgumentException("Sliding interval must be positive [" + windowConfig.getSlidingIntervalCount() + "]");
        }
        if (windowConfig.getSlidingIntervalDurationMs() != null && windowConfig.getSlidingIntervalDurationMs() <= 0L) {
            throw new IllegalArgumentException("Sliding interval must be positive [" + windowConfig.getSlidingIntervalDurationMs() + "]");
        }
        if (windowConfig.getTimestampExtractorClassName() != null) {
            if (windowConfig.getMaxLagMs() != null && windowConfig.getMaxLagMs() < 0L) {
                throw new IllegalArgumentException("Lag duration must be positive [" + windowConfig.getMaxLagMs() + "]");
            }
            if (windowConfig.getWatermarkEmitIntervalMs() != null && windowConfig.getWatermarkEmitIntervalMs() <= 0L) {
                throw new IllegalArgumentException("Watermark interval must be positive [" + windowConfig.getWatermarkEmitIntervalMs() + "]");
            }
        }
    }

    public static void inferMissingArguments(WindowConfig windowConfig) {
        if (windowConfig.getWindowLengthDurationMs() != null && windowConfig.getSlidingIntervalDurationMs() == null) {
            windowConfig.setSlidingIntervalDurationMs(windowConfig.getWindowLengthDurationMs());
        }
        if (windowConfig.getWindowLengthCount() != null && windowConfig.getSlidingIntervalCount() == null) {
            windowConfig.setSlidingIntervalCount(windowConfig.getWindowLengthCount());
        }
        if (windowConfig.getTimestampExtractorClassName() != null) {
            if (windowConfig.getMaxLagMs() == null) {
                windowConfig.setMaxLagMs(0L);
            }
            if (windowConfig.getWatermarkEmitIntervalMs() == null) {
                windowConfig.setWatermarkEmitIntervalMs(1000L);
            }
        }
    }
}

