/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker.rest;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Optional;
import org.apache.pulsar.broker.authentication.AuthenticationService;
import org.apache.pulsar.broker.web.AuthenticationFilter;
import org.apache.pulsar.broker.web.JettyRequestLogFactory;
import org.apache.pulsar.broker.web.RateLimitingFilter;
import org.apache.pulsar.broker.web.WebExecutorThreadPool;
import org.apache.pulsar.functions.worker.WorkerConfig;
import org.apache.pulsar.functions.worker.WorkerService;
import org.apache.pulsar.functions.worker.rest.Resources;
import org.apache.pulsar.shade.io.prometheus.client.jetty.JettyStatisticsCollector;
import org.apache.pulsar.shade.javax.servlet.DispatcherType;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.SecurityUtility;
import org.apache.pulsar.shade.org.eclipse.jetty.server.Handler;
import org.apache.pulsar.shade.org.eclipse.jetty.server.Server;
import org.apache.pulsar.shade.org.eclipse.jetty.server.ServerConnector;
import org.apache.pulsar.shade.org.eclipse.jetty.server.handler.AbstractHandlerContainer;
import org.apache.pulsar.shade.org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.apache.pulsar.shade.org.eclipse.jetty.server.handler.DefaultHandler;
import org.apache.pulsar.shade.org.eclipse.jetty.server.handler.HandlerCollection;
import org.apache.pulsar.shade.org.eclipse.jetty.server.handler.RequestLogHandler;
import org.apache.pulsar.shade.org.eclipse.jetty.server.handler.StatisticsHandler;
import org.apache.pulsar.shade.org.eclipse.jetty.servlet.FilterHolder;
import org.apache.pulsar.shade.org.eclipse.jetty.servlet.ServletContextHandler;
import org.apache.pulsar.shade.org.eclipse.jetty.servlet.ServletHolder;
import org.apache.pulsar.shade.org.eclipse.jetty.util.ssl.SslContextFactory;
import org.apache.pulsar.shade.org.glassfish.jersey.server.ResourceConfig;
import org.apache.pulsar.shade.org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerServer {
    private static final Logger log = LoggerFactory.getLogger(WorkerServer.class);
    private final WorkerConfig workerConfig;
    private final WorkerService workerService;
    private final AuthenticationService authenticationService;
    private static final String MATCH_ALL = "/*";
    private static final int MAX_CONCURRENT_REQUESTS = 1024;
    private final WebExecutorThreadPool webServerExecutor;
    private Server server;
    private ServerConnector httpConnector;
    private ServerConnector httpsConnector;

    public WorkerServer(WorkerService workerService, AuthenticationService authenticationService) {
        this.workerConfig = workerService.getWorkerConfig();
        this.workerService = workerService;
        this.authenticationService = authenticationService;
        this.webServerExecutor = new WebExecutorThreadPool(this.workerConfig.getNumHttpServerThreads(), "function-web");
        this.init();
    }

    public void start() throws Exception {
        this.server.start();
        log.info("Worker Server started at {}", (Object)this.server.getURI());
    }

    private void init() {
        this.server = new Server(this.webServerExecutor);
        ArrayList<ServerConnector> connectors = new ArrayList<ServerConnector>();
        this.httpConnector = new ServerConnector(this.server, 1, 1);
        this.httpConnector.setPort(this.workerConfig.getWorkerPort());
        connectors.add(this.httpConnector);
        ArrayList<AbstractHandlerContainer> handlers = new ArrayList<AbstractHandlerContainer>(4);
        handlers.add(WorkerServer.newServletContextHandler("/admin", new ResourceConfig(Resources.getApiV2Resources()), this.workerService, this.authenticationService));
        handlers.add(WorkerServer.newServletContextHandler("/admin/v2", new ResourceConfig(Resources.getApiV2Resources()), this.workerService, this.authenticationService));
        handlers.add(WorkerServer.newServletContextHandler("/admin/v3", new ResourceConfig(Resources.getApiV3Resources()), this.workerService, this.authenticationService));
        handlers.add(WorkerServer.newServletContextHandler("/", new ResourceConfig(Resources.getRootResources()), this.workerService, this.workerConfig.isAuthenticateMetricsEndpoint(), this.authenticationService));
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        requestLogHandler.setRequestLog(JettyRequestLogFactory.createRequestLogger());
        handlers.add(0, new ContextHandlerCollection());
        handlers.add(requestLogHandler);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        contexts.setHandlers(handlers.toArray(new Handler[handlers.size()]));
        HandlerCollection handlerCollection = new HandlerCollection();
        handlerCollection.setHandlers(new Handler[]{contexts, new DefaultHandler(), requestLogHandler});
        StatisticsHandler stats = new StatisticsHandler();
        stats.setHandler(handlerCollection);
        try {
            new JettyStatisticsCollector(stats).register();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        handlers.add(stats);
        this.server.setHandler(stats);
        if (this.workerConfig.getTlsEnabled()) {
            try {
                SslContextFactory sslCtxFactory = SecurityUtility.createSslContextFactory(this.workerConfig.isTlsAllowInsecureConnection(), this.workerConfig.getTlsTrustCertsFilePath(), this.workerConfig.getTlsCertificateFilePath(), this.workerConfig.getTlsKeyFilePath(), this.workerConfig.isTlsRequireTrustedClientCertOnConnect(), true, this.workerConfig.getTlsCertRefreshCheckDurationSec());
                this.httpsConnector = new ServerConnector(this.server, 1, 1, sslCtxFactory);
                this.httpsConnector.setPort(this.workerConfig.getWorkerPortTls());
                connectors.add(this.httpsConnector);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        connectors.forEach(c -> c.setAcceptQueueSize(1024 / connectors.size()));
        this.server.setConnectors(connectors.toArray(new ServerConnector[connectors.size()]));
    }

    public static ServletContextHandler newServletContextHandler(String contextPath, ResourceConfig config, WorkerService workerService, AuthenticationService authenticationService) {
        return WorkerServer.newServletContextHandler(contextPath, config, workerService, true, authenticationService);
    }

    public static ServletContextHandler newServletContextHandler(String contextPath, ResourceConfig config, WorkerService workerService, boolean requireAuthentication, AuthenticationService authenticationService) {
        ServletContextHandler contextHandler = new ServletContextHandler(0);
        contextHandler.setAttribute("function-worker", workerService);
        contextHandler.setAttribute("worker", workerService);
        contextHandler.setAttribute("worker-stats", workerService);
        contextHandler.setContextPath(contextPath);
        ServletHolder apiServlet = new ServletHolder(new ServletContainer(config));
        contextHandler.addServlet(apiServlet, MATCH_ALL);
        if (workerService.getWorkerConfig().isAuthenticationEnabled() && requireAuthentication) {
            FilterHolder filter = new FilterHolder(new AuthenticationFilter(authenticationService));
            contextHandler.addFilter(filter, MATCH_ALL, EnumSet.allOf(DispatcherType.class));
        }
        if (workerService.getWorkerConfig().isHttpRequestsLimitEnabled()) {
            contextHandler.addFilter(new FilterHolder(new RateLimitingFilter(workerService.getWorkerConfig().getHttpRequestsMaxPerSecond())), MATCH_ALL, EnumSet.allOf(DispatcherType.class));
        }
        return contextHandler;
    }

    public void stop() {
        if (this.server != null) {
            try {
                this.server.stop();
                this.server.destroy();
            }
            catch (Exception e) {
                log.error("Failed to stop function web-server ", (Throwable)e);
            }
        }
        if (this.webServerExecutor != null && this.webServerExecutor.isRunning()) {
            try {
                this.webServerExecutor.stop();
            }
            catch (Exception e) {
                log.warn("Error stopping function web-server executor", (Throwable)e);
            }
        }
    }

    public Optional<Integer> getListenPortHTTP() {
        if (this.httpConnector != null) {
            return Optional.of(this.httpConnector.getLocalPort());
        }
        return Optional.empty();
    }

    public Optional<Integer> getListenPortHTTPS() {
        if (this.httpsConnector != null) {
            return Optional.of(this.httpsConnector.getLocalPort());
        }
        return Optional.empty();
    }
}

