/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.yahoo.sketches.theta;

import com.yahoo.memory.Memory;
import java.util.Arrays;
import org.apache.pulsar.shade.com.yahoo.sketches.Family;
import org.apache.pulsar.shade.com.yahoo.sketches.SketchesArgumentException;
import org.apache.pulsar.shade.com.yahoo.sketches.theta.DirectCompactOrderedSketch;
import org.apache.pulsar.shade.com.yahoo.sketches.theta.DirectCompactSketch;
import org.apache.pulsar.shade.com.yahoo.sketches.theta.HeapCompactOrderedSketch;
import org.apache.pulsar.shade.com.yahoo.sketches.theta.HeapCompactSketch;
import org.apache.pulsar.shade.com.yahoo.sketches.theta.PreambleUtil;
import org.apache.pulsar.shade.com.yahoo.sketches.theta.Sketch;

public abstract class CompactSketch
extends Sketch {
    private final short seedHash_;
    private final boolean empty_;
    private final int curCount_;
    private final long thetaLong_;

    CompactSketch(boolean empty, short seedHash, int curCount, long thetaLong) {
        this.empty_ = empty;
        this.seedHash_ = seedHash;
        this.curCount_ = curCount;
        this.thetaLong_ = thetaLong;
    }

    @Override
    public int getRetainedEntries(boolean valid) {
        return this.curCount_;
    }

    @Override
    public boolean isEmpty() {
        return this.empty_;
    }

    @Override
    public boolean isEstimationMode() {
        return Sketch.estMode(this.getThetaLong(), this.isEmpty());
    }

    @Override
    public Family getFamily() {
        return Family.COMPACT;
    }

    @Override
    public boolean isCompact() {
        return true;
    }

    @Override
    short getSeedHash() {
        return this.seedHash_;
    }

    @Override
    long getThetaLong() {
        return this.thetaLong_;
    }

    @Override
    int getPreambleLongs() {
        return CompactSketch.compactPreambleLongs(this.getThetaLong(), this.isEmpty());
    }

    static final long[] compactCache(long[] srcCache, int curCount, long thetaLong, boolean dstOrdered) {
        if (curCount == 0) {
            return new long[0];
        }
        long[] cacheOut = new long[curCount];
        int len = srcCache.length;
        int j = 0;
        for (int i = 0; i < len; ++i) {
            long v = srcCache[i];
            if (v <= 0L || v >= thetaLong) continue;
            cacheOut[j++] = v;
        }
        assert (curCount == j);
        if (dstOrdered) {
            Arrays.sort(cacheOut);
        }
        return cacheOut;
    }

    static final long[] compactCachePart(long[] srcCache, int lgArrLongs, int curCount, long thetaLong, boolean dstOrdered) {
        if (curCount == 0) {
            return new long[0];
        }
        long[] cacheOut = new long[curCount];
        int len = 1 << lgArrLongs;
        int j = 0;
        for (int i = 0; i < len; ++i) {
            long v = srcCache[i];
            if (v <= 0L || v >= thetaLong) continue;
            cacheOut[j++] = v;
        }
        assert (curCount == j);
        if (dstOrdered) {
            Arrays.sort(cacheOut);
        }
        return cacheOut;
    }

    static final CompactSketch createCompactSketch(long[] compactCache, boolean empty, short seedHash, int curCount, long thetaLong, boolean dstOrdered, Memory dstMem) {
        CompactSketch sketchOut = null;
        int sw = (dstOrdered ? 2 : 0) | (dstMem != null ? 1 : 0);
        switch (sw) {
            case 0: {
                sketchOut = new HeapCompactSketch(compactCache, empty, seedHash, curCount, thetaLong);
                break;
            }
            case 1: {
                sketchOut = new DirectCompactSketch(compactCache, empty, seedHash, curCount, thetaLong, dstMem);
                break;
            }
            case 2: {
                sketchOut = new HeapCompactOrderedSketch(compactCache, empty, seedHash, curCount, thetaLong);
                break;
            }
            case 3: {
                sketchOut = new DirectCompactOrderedSketch(compactCache, empty, seedHash, curCount, thetaLong, dstMem);
            }
        }
        return sketchOut;
    }

    static final Memory loadCompactMemory(long[] compactCache, boolean empty, short seedHash, int curCount, long thetaLong, Memory dstMem, byte flags) {
        int dstBytes;
        int preLongs = CompactSketch.compactPreambleLongs(thetaLong, empty);
        int outLongs = preLongs + curCount;
        int outBytes = outLongs << 3;
        if (outBytes > (dstBytes = (int)dstMem.getCapacity())) {
            throw new SketchesArgumentException("Insufficient Memory: " + dstBytes + ", Need: " + outBytes);
        }
        byte famID = (byte)Family.stringToFamily("Compact").getID();
        long[] outArr = new long[outLongs];
        long pre0 = 0L;
        pre0 = PreambleUtil.insertPreLongs(preLongs, pre0);
        pre0 = PreambleUtil.insertSerVer(3, pre0);
        pre0 = PreambleUtil.insertFamilyID(famID, pre0);
        pre0 = PreambleUtil.insertFlags(flags, pre0);
        outArr[0] = pre0 = PreambleUtil.insertSeedHash(seedHash, pre0);
        if (preLongs > 1) {
            long pre1 = 0L;
            pre1 = PreambleUtil.insertCurCount(curCount, pre1);
            outArr[1] = pre1 = PreambleUtil.insertP(1.0f, pre1);
        }
        if (preLongs > 2) {
            outArr[2] = thetaLong;
        }
        if (compactCache != null && curCount > 0) {
            System.arraycopy(compactCache, 0, outArr, preLongs, curCount);
        }
        dstMem.putLongArray(0L, outArr, 0, outLongs);
        return dstMem;
    }
}

