/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.api.kv.impl.op;

import org.apache.pulsar.shade.io.netty.util.Recycler;
import org.apache.pulsar.shade.io.netty.util.ReferenceCountUtil;
import org.apache.pulsar.shade.org.apache.bookkeeper.api.kv.op.OpType;
import org.apache.pulsar.shade.org.apache.bookkeeper.api.kv.op.PutOp;
import org.apache.pulsar.shade.org.apache.bookkeeper.api.kv.options.PutOption;

class PutOpImpl<K, V>
implements PutOp<K, V> {
    private final Recycler.Handle<PutOpImpl<K, V>> handle;
    private K key;
    private V value;
    private PutOption<K> option;

    @Override
    public OpType type() {
        return OpType.PUT;
    }

    PutOpImpl<K, V> key(K key) {
        ReferenceCountUtil.release(this.key);
        this.key = ReferenceCountUtil.retain(key);
        return this;
    }

    PutOpImpl<K, V> value(V value) {
        ReferenceCountUtil.release(this.value);
        this.value = ReferenceCountUtil.retain(value);
        return this;
    }

    @Override
    public void close() {
        ReferenceCountUtil.release(this.key);
        this.key = null;
        ReferenceCountUtil.release(this.value);
        this.value = null;
        if (null != this.option) {
            this.option.close();
            this.option = null;
        }
        this.handle.recycle(this);
    }

    public Recycler.Handle<PutOpImpl<K, V>> handle() {
        return this.handle;
    }

    @Override
    public K key() {
        return this.key;
    }

    @Override
    public V value() {
        return this.value;
    }

    @Override
    public PutOption<K> option() {
        return this.option;
    }

    PutOpImpl<K, V> option(PutOption<K> option) {
        this.option = option;
        return this;
    }

    PutOpImpl(Recycler.Handle<PutOpImpl<K, V>> handle) {
        this.handle = handle;
    }

    public String toString() {
        return "PutOpImpl(key=" + this.key() + ", value=" + this.value() + ", option=" + this.option() + ")";
    }
}

