/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.bookie;

import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.apache.pulsar.shade.io.netty.util.HashedWheelTimer;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.Bookie;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.BKException;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.BookieInfoReader;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.BookiesHealthInfo;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.DistributionSchedule;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.EnsemblePlacementPolicy;
import org.apache.pulsar.shade.org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.feature.FeatureProvider;
import org.apache.pulsar.shade.org.apache.bookkeeper.net.BookieId;
import org.apache.pulsar.shade.org.apache.bookkeeper.net.DNSToSwitchMapping;
import org.apache.pulsar.shade.org.apache.bookkeeper.proto.BookieAddressResolver;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.StatsLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalBookieEnsemblePlacementPolicy
implements EnsemblePlacementPolicy {
    static final Logger LOG = LoggerFactory.getLogger(LocalBookieEnsemblePlacementPolicy.class);
    private BookieId bookieAddress;

    @Override
    public EnsemblePlacementPolicy initialize(ClientConfiguration conf, Optional<DNSToSwitchMapping> optionalDnsResolver, HashedWheelTimer hashedWheelTimer, FeatureProvider featureProvider, StatsLogger statsLogger, BookieAddressResolver bookieAddressResolver) {
        ServerConfiguration serverConf = new ServerConfiguration();
        serverConf.addConfiguration(conf);
        try {
            this.bookieAddress = Bookie.getBookieId(serverConf);
        }
        catch (UnknownHostException e) {
            LOG.warn("Unable to get bookie address", (Throwable)e);
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public void uninitalize() {
    }

    @Override
    public Set<BookieId> onClusterChanged(Set<BookieId> writableBookies, Set<BookieId> readOnlyBookies) {
        return Collections.emptySet();
    }

    @Override
    public EnsemblePlacementPolicy.PlacementResult<BookieId> replaceBookie(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Map<String, byte[]> customMetadata, List<BookieId> currentEnsemble, BookieId bookieToReplace, Set<BookieId> excludeBookies) throws BKException.BKNotEnoughBookiesException {
        throw new BKException.BKNotEnoughBookiesException();
    }

    @Override
    public void registerSlowBookie(BookieId bookieSocketAddress, long entryId) {
    }

    @Override
    public DistributionSchedule.WriteSet reorderReadSequence(List<BookieId> ensemble, BookiesHealthInfo bookiesHealthInfo, DistributionSchedule.WriteSet writeSet) {
        return null;
    }

    @Override
    public DistributionSchedule.WriteSet reorderReadLACSequence(List<BookieId> ensemble, BookiesHealthInfo bookiesHealthInfo, DistributionSchedule.WriteSet writeSet) {
        return null;
    }

    @Override
    public EnsemblePlacementPolicy.PlacementResult<List<BookieId>> newEnsemble(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Map<String, byte[]> customMetadata, Set<BookieId> excludeBookies) throws BKException.BKNotEnoughBookiesException {
        if (ensembleSize > 1) {
            throw new IllegalArgumentException("Local ensemble policy can only return 1 bookie");
        }
        return EnsemblePlacementPolicy.PlacementResult.of(Lists.newArrayList(this.bookieAddress), EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_STRICT);
    }

    @Override
    public void updateBookieInfo(Map<BookieId, BookieInfoReader.BookieInfo> bookieToFreeSpaceMap) {
    }

    @Override
    public EnsemblePlacementPolicy.PlacementPolicyAdherence isEnsembleAdheringToPlacementPolicy(List<BookieId> ensembleList, int writeQuorumSize, int ackQuorumSize) {
        return EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_STRICT;
    }
}

