/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.bookie.storage.ldb;

import java.io.Closeable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.ByteBufAllocator;
import org.apache.pulsar.shade.io.netty.buffer.Unpooled;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.storage.ldb.ArrayGroupSort;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.MathUtils;
import org.apache.pulsar.shade.org.apache.bookkeeper.util.collections.ConcurrentLongHashSet;
import org.apache.pulsar.shade.org.apache.bookkeeper.util.collections.ConcurrentLongLongHashMap;
import org.apache.pulsar.shade.org.apache.bookkeeper.util.collections.ConcurrentLongLongPairHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteCache
implements Closeable {
    private final ConcurrentLongLongPairHashMap index = new ConcurrentLongLongPairHashMap(4096, 2 * Runtime.getRuntime().availableProcessors());
    private final ConcurrentLongLongHashMap lastEntryMap = new ConcurrentLongLongHashMap(4096, 2 * Runtime.getRuntime().availableProcessors());
    private final ByteBuf[] cacheSegments;
    private final int segmentsCount;
    private final long maxCacheSize;
    private final int maxSegmentSize;
    private final long segmentOffsetMask;
    private final long segmentOffsetBits;
    private final AtomicLong cacheSize = new AtomicLong(0L);
    private final AtomicLong cacheOffset = new AtomicLong(0L);
    private final LongAdder cacheCount = new LongAdder();
    private final ConcurrentLongHashSet deletedLedgers = new ConcurrentLongHashSet();
    private final ByteBufAllocator allocator;
    private static final ArrayGroupSort groupSorter = new ArrayGroupSort(2, 4);
    private static final int ALIGN_64_MASK = -64;
    private final ReentrantLock sortedEntriesLock = new ReentrantLock();
    private long[] sortedEntries;
    private int sortedEntriesIdx;
    private static final Logger log = LoggerFactory.getLogger(WriteCache.class);

    public WriteCache(ByteBufAllocator allocator, long maxCacheSize) {
        this(allocator, maxCacheSize, 0x40000000);
    }

    public WriteCache(ByteBufAllocator allocator, long maxCacheSize, int maxSegmentSize) {
        Preconditions.checkArgument(maxSegmentSize > 0);
        long alignedMaxSegmentSize = WriteCache.alignToPowerOfTwo(maxSegmentSize);
        Preconditions.checkArgument((long)maxSegmentSize == alignedMaxSegmentSize, "Max segment size needs to be in form of 2^n");
        this.allocator = allocator;
        this.maxCacheSize = maxCacheSize;
        this.maxSegmentSize = maxSegmentSize;
        this.segmentOffsetMask = maxSegmentSize - 1;
        this.segmentOffsetBits = 63 - Long.numberOfLeadingZeros(maxSegmentSize);
        this.segmentsCount = 1 + (int)(maxCacheSize / (long)maxSegmentSize);
        this.cacheSegments = new ByteBuf[this.segmentsCount];
        for (int i = 0; i < this.segmentsCount - 1; ++i) {
            this.cacheSegments[i] = Unpooled.directBuffer(maxSegmentSize, maxSegmentSize);
        }
        int lastSegmentSize = (int)(maxCacheSize % (long)maxSegmentSize);
        this.cacheSegments[this.segmentsCount - 1] = Unpooled.directBuffer(lastSegmentSize, lastSegmentSize);
    }

    public void clear() {
        this.cacheSize.set(0L);
        this.cacheOffset.set(0L);
        this.cacheCount.reset();
        this.index.clear();
        this.lastEntryMap.clear();
        this.deletedLedgers.clear();
    }

    @Override
    public void close() {
        for (ByteBuf buf : this.cacheSegments) {
            buf.release();
        }
    }

    public boolean put(long ledgerId, long entryId, ByteBuf entry) {
        long currentLastEntryId;
        int segmentIdx;
        long offset;
        int localOffset;
        int size = entry.readableBytes();
        int alignedSize = WriteCache.align64(size);
        do {
            offset = this.cacheOffset.getAndAdd(alignedSize);
            localOffset = (int)(offset & this.segmentOffsetMask);
            segmentIdx = (int)(offset >>> (int)this.segmentOffsetBits);
            if (offset + (long)size <= this.maxCacheSize) continue;
            return false;
        } while (this.maxSegmentSize - localOffset < size);
        this.cacheSegments[segmentIdx].setBytes(localOffset, entry, entry.readerIndex(), entry.readableBytes());
        while ((currentLastEntryId = this.lastEntryMap.get(ledgerId)) <= entryId && !this.lastEntryMap.compareAndSet(ledgerId, currentLastEntryId, entryId)) {
        }
        this.index.put(ledgerId, entryId, offset, size);
        this.cacheCount.increment();
        this.cacheSize.addAndGet(size);
        return true;
    }

    public ByteBuf get(long ledgerId, long entryId) {
        ConcurrentLongLongPairHashMap.LongPair result = this.index.get(ledgerId, entryId);
        if (result == null) {
            return null;
        }
        long offset = result.first;
        int size = (int)result.second;
        ByteBuf entry = this.allocator.buffer(size, size);
        int localOffset = (int)(offset & this.segmentOffsetMask);
        int segmentIdx = (int)(offset >>> (int)this.segmentOffsetBits);
        entry.writeBytes(this.cacheSegments[segmentIdx], localOffset, size);
        return entry;
    }

    public ByteBuf getLastEntry(long ledgerId) {
        long lastEntryId = this.lastEntryMap.get(ledgerId);
        if (lastEntryId == -1L) {
            return null;
        }
        return this.get(ledgerId, lastEntryId);
    }

    public void deleteLedger(long ledgerId) {
        this.deletedLedgers.add(ledgerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEach(EntryConsumer consumer) {
        this.sortedEntriesLock.lock();
        try {
            int i;
            int entriesToSort = (int)this.index.size();
            int arrayLen = entriesToSort * 4;
            if (this.sortedEntries == null || this.sortedEntries.length < arrayLen) {
                this.sortedEntries = new long[arrayLen * 2];
            }
            long startTime = MathUtils.nowInNano();
            this.sortedEntriesIdx = 0;
            this.index.forEach((long ledgerId, long entryId, long offset, long length) -> {
                if (this.deletedLedgers.contains(ledgerId)) {
                    return;
                }
                this.sortedEntries[this.sortedEntriesIdx] = ledgerId;
                this.sortedEntries[this.sortedEntriesIdx + 1] = entryId;
                this.sortedEntries[this.sortedEntriesIdx + 2] = offset;
                this.sortedEntries[this.sortedEntriesIdx + 3] = length;
                this.sortedEntriesIdx += 4;
            });
            if (log.isDebugEnabled()) {
                log.debug("iteration took {} ms", (Object)((double)MathUtils.elapsedNanos(startTime) / 1000000.0));
            }
            startTime = MathUtils.nowInNano();
            groupSorter.sort(this.sortedEntries, 0, this.sortedEntriesIdx);
            if (log.isDebugEnabled()) {
                log.debug("sorting {} ms", (Object)((double)MathUtils.elapsedNanos(startTime) / 1000000.0));
            }
            startTime = MathUtils.nowInNano();
            ByteBuf[] entrySegments = new ByteBuf[this.segmentsCount];
            for (i = 0; i < this.segmentsCount; ++i) {
                entrySegments[i] = this.cacheSegments[i].slice(0, this.cacheSegments[i].capacity());
            }
            for (i = 0; i < this.sortedEntriesIdx; i += 4) {
                long ledgerId2 = this.sortedEntries[i];
                long entryId2 = this.sortedEntries[i + 1];
                long offset2 = this.sortedEntries[i + 2];
                long length2 = this.sortedEntries[i + 3];
                int localOffset = (int)(offset2 & this.segmentOffsetMask);
                int segmentIdx = (int)(offset2 >>> (int)this.segmentOffsetBits);
                ByteBuf entry = entrySegments[segmentIdx];
                entry.setIndex(localOffset, localOffset + (int)length2);
                consumer.accept(ledgerId2, entryId2, entry);
            }
            if (log.isDebugEnabled()) {
                log.debug("entry log adding {} ms", (Object)((double)MathUtils.elapsedNanos(startTime) / 1000000.0));
            }
        }
        finally {
            this.sortedEntriesLock.unlock();
        }
    }

    public long size() {
        return this.cacheSize.get();
    }

    public long count() {
        return this.cacheCount.sum();
    }

    public boolean isEmpty() {
        return this.cacheSize.get() == 0L;
    }

    static int align64(int size) {
        return size + 64 - 1 & 0xFFFFFFC0;
    }

    private static long alignToPowerOfTwo(long n) {
        return (long)Math.pow(2.0, 64 - Long.numberOfLeadingZeros(n - 1L));
    }

    public static interface EntryConsumer {
        public void accept(long var1, long var3, ByteBuf var5);
    }
}

