/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.client.api;

import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.Unpooled;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.api.BKException;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.api.ForceableHandle;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.api.ReadHandle;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.annotation.InterfaceAudience;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.annotation.InterfaceStability;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.concurrent.FutureUtils;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public interface WriteAdvHandle
extends ReadHandle,
ForceableHandle {
    default public CompletableFuture<Long> writeAsync(long entryId, ByteBuffer data) {
        return this.writeAsync(entryId, Unpooled.wrappedBuffer(data));
    }

    default public long write(long entryId, ByteBuffer data) throws BKException, InterruptedException {
        return this.write(entryId, Unpooled.wrappedBuffer(data));
    }

    default public CompletableFuture<Long> writeAsync(long entryId, byte[] data) {
        return this.writeAsync(entryId, Unpooled.wrappedBuffer(data));
    }

    default public long write(long entryId, byte[] data) throws BKException, InterruptedException {
        return this.write(entryId, Unpooled.wrappedBuffer(data));
    }

    default public CompletableFuture<Long> writeAsync(long entryId, byte[] data, int offset, int length) {
        return this.writeAsync(entryId, Unpooled.wrappedBuffer(data, offset, length));
    }

    default public long write(long entryId, byte[] data, int offset, int length) throws BKException, InterruptedException {
        return this.write(entryId, Unpooled.wrappedBuffer(data, offset, length));
    }

    public CompletableFuture<Long> writeAsync(long var1, ByteBuf var3);

    default public long write(long entryId, ByteBuf data) throws BKException, InterruptedException {
        return FutureUtils.result(this.writeAsync(entryId, data), BKException.HANDLER);
    }
}

