/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.clients;

import java.util.function.Supplier;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.org.apache.bookkeeper.api.StorageClient;
import org.apache.pulsar.shade.org.apache.bookkeeper.clients.SimpleStorageClientImpl;
import org.apache.pulsar.shade.org.apache.bookkeeper.clients.StorageClientImpl;
import org.apache.pulsar.shade.org.apache.bookkeeper.clients.admin.SimpleStorageAdminClientImpl;
import org.apache.pulsar.shade.org.apache.bookkeeper.clients.admin.StorageAdminClient;
import org.apache.pulsar.shade.org.apache.bookkeeper.clients.admin.StorageAdminClientImpl;
import org.apache.pulsar.shade.org.apache.bookkeeper.clients.config.StorageClientSettings;
import org.apache.pulsar.shade.org.apache.bookkeeper.clients.utils.ClientResources;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.protocol.util.ProtoUtils;

public class StorageClientBuilder
implements Supplier<StorageClient> {
    private StorageClientSettings settings = null;
    private String namespaceName = null;

    public static StorageClientBuilder newBuilder() {
        return new StorageClientBuilder();
    }

    private StorageClientBuilder() {
    }

    public StorageClientBuilder withSettings(StorageClientSettings settings) {
        this.settings = settings;
        return this;
    }

    public StorageClientBuilder withNamespace(String colName) {
        this.namespaceName = colName;
        return this;
    }

    public StorageClient build() {
        Preconditions.checkNotNull(this.settings, "Stream settings is null");
        Preconditions.checkArgument(ProtoUtils.validateNamespaceName(this.namespaceName), "Namespace name '" + this.namespaceName + "'is invalid");
        if (this.settings.enableServerSideRouting()) {
            return new SimpleStorageClientImpl(this.namespaceName, this.settings);
        }
        return new StorageClientImpl(this.namespaceName, this.settings, ClientResources.create());
    }

    public StorageAdminClient buildAdmin() {
        Preconditions.checkNotNull(this.settings, "Storage client settings is null");
        if (this.settings.enableServerSideRouting()) {
            return new SimpleStorageAdminClientImpl(this.settings);
        }
        return new StorageAdminClientImpl(this.settings, ClientResources.create());
    }

    @Override
    public StorageClient get() {
        return this.build();
    }
}

