/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.meta;

import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import org.apache.pulsar.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.common.collect.Sets;
import org.apache.pulsar.shade.com.google.common.util.concurrent.UncheckedExecutionException;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.ReflectionUtils;
import org.apache.pulsar.shade.org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.MetadataBookieDriver;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.MetadataClientDriver;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.exceptions.Code;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.exceptions.MetadataException;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.pulsar.shade.org.apache.commons.configuration.ConfigurationException;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetadataDrivers {
    private static final Logger log = LoggerFactory.getLogger(MetadataDrivers.class);
    static final String ZK_CLIENT_DRIVER_CLASS = "org.apache.pulsar.shade.org.apache.bookkeeper.meta.zk.ZKMetadataClientDriver";
    static final String ZK_BOOKIE_DRIVER_CLASS = "org.apache.pulsar.shade.org.apache.bookkeeper.meta.zk.ZKMetadataBookieDriver";
    static final String BK_METADATA_CLIENT_DRIVERS_PROPERTY = "bookkeeper.metadata.client.drivers";
    static final String BK_METADATA_BOOKIE_DRIVERS_PROPERTY = "bookkeeper.metadata.bookie.drivers";
    private static final ConcurrentMap<String, MetadataClientDriverInfo> clientDrivers = new ConcurrentHashMap<String, MetadataClientDriverInfo>();
    private static final ConcurrentMap<String, MetadataBookieDriverInfo> bookieDrivers = new ConcurrentHashMap<String, MetadataBookieDriverInfo>();

    @VisibleForTesting
    static void loadInitialDrivers() {
        MetadataDrivers.loadInitialClientDrivers();
        MetadataDrivers.loadInitialBookieDrivers();
        log.info("BookKeeper metadata driver manager initialized");
    }

    private static void loadInitialClientDrivers() {
        HashSet<String> driverList = Sets.newHashSet();
        driverList.add(ZK_CLIENT_DRIVER_CLASS);
        String driversStr = System.getProperty(BK_METADATA_CLIENT_DRIVERS_PROPERTY);
        if (null != driversStr) {
            String[] driversArray = StringUtils.split(driversStr, ':');
            Collections.addAll(driverList, driversArray);
        }
        for (String driverClsName : driverList) {
            try {
                MetadataClientDriver driver = ReflectionUtils.newInstance(driverClsName, MetadataClientDriver.class);
                MetadataClientDriverInfo driverInfo = new MetadataClientDriverInfo(driver.getClass());
                clientDrivers.put(driver.getScheme().toLowerCase(), driverInfo);
            }
            catch (Exception e) {
                log.warn("Failed to load metadata client driver {}", (Object)driverClsName, (Object)e);
            }
        }
    }

    private static void loadInitialBookieDrivers() {
        HashSet<String> driverList = Sets.newHashSet();
        driverList.add(ZK_BOOKIE_DRIVER_CLASS);
        String driversStr = System.getProperty(BK_METADATA_BOOKIE_DRIVERS_PROPERTY);
        if (null != driversStr) {
            String[] driversArray = StringUtils.split(driversStr, ':');
            Collections.addAll(driverList, driversArray);
        }
        for (String driverClsName : driverList) {
            try {
                MetadataBookieDriver driver = ReflectionUtils.newInstance(driverClsName, MetadataBookieDriver.class);
                MetadataBookieDriverInfo driverInfo = new MetadataBookieDriverInfo(driver.getClass());
                bookieDrivers.put(driver.getScheme().toLowerCase(), driverInfo);
            }
            catch (Exception e) {
                log.warn("Failed to load metadata bookie driver {}", (Object)driverClsName, (Object)e);
            }
        }
    }

    public static void registerClientDriver(String metadataBackendScheme, Class<? extends MetadataClientDriver> driver) {
        MetadataDrivers.registerClientDriver(metadataBackendScheme, driver, false);
    }

    @VisibleForTesting
    public static void registerClientDriver(String metadataBackendScheme, Class<? extends MetadataClientDriver> driver, boolean allowOverride) {
        String scheme = metadataBackendScheme.toLowerCase();
        MetadataClientDriverInfo oldDriverInfo = (MetadataClientDriverInfo)clientDrivers.get(scheme);
        if (null != oldDriverInfo && !allowOverride) {
            return;
        }
        MetadataClientDriverInfo newDriverInfo = new MetadataClientDriverInfo(driver);
        oldDriverInfo = clientDrivers.putIfAbsent(scheme, newDriverInfo);
        if (null != oldDriverInfo) {
            log.debug("Metadata client driver for {} is already there.", (Object)scheme);
            if (allowOverride) {
                log.debug("Overriding client driver for {}", (Object)scheme);
                clientDrivers.put(scheme, newDriverInfo);
            }
        }
    }

    public static void registerBookieDriver(String metadataBackendScheme, Class<? extends MetadataBookieDriver> driver) {
        MetadataDrivers.registerBookieDriver(metadataBackendScheme, driver, false);
    }

    @VisibleForTesting
    public static void registerBookieDriver(String metadataBackendScheme, Class<? extends MetadataBookieDriver> driver, boolean allowOverride) {
        String scheme = metadataBackendScheme.toLowerCase();
        MetadataBookieDriverInfo oldDriverInfo = (MetadataBookieDriverInfo)bookieDrivers.get(scheme);
        if (null != oldDriverInfo && !allowOverride) {
            return;
        }
        MetadataBookieDriverInfo newDriverInfo = new MetadataBookieDriverInfo(driver);
        oldDriverInfo = bookieDrivers.putIfAbsent(scheme, newDriverInfo);
        if (null != oldDriverInfo) {
            log.debug("Metadata bookie driver for {} is already there.", (Object)scheme);
            if (allowOverride) {
                log.debug("Overriding bookie driver for {}", (Object)scheme);
                bookieDrivers.put(scheme, newDriverInfo);
            }
        }
    }

    public static MetadataClientDriver getClientDriver(String scheme) {
        Preconditions.checkNotNull(scheme, "Client Driver Scheme is null");
        MetadataClientDriverInfo driverInfo = (MetadataClientDriverInfo)clientDrivers.get(scheme.toLowerCase());
        if (null == driverInfo) {
            throw new IllegalArgumentException("Unknown backend " + scheme);
        }
        return ReflectionUtils.newInstance(driverInfo.driverClass);
    }

    public static MetadataClientDriver getClientDriver(URI uri) {
        Preconditions.checkNotNull(uri, "Metadata service uri is null");
        String scheme = uri.getScheme();
        Preconditions.checkNotNull(scheme, "Invalid metadata service uri : " + uri);
        scheme = scheme.toLowerCase();
        String[] schemeParts = StringUtils.split(scheme, '+');
        Preconditions.checkArgument(schemeParts.length > 0, "Invalid metadata service scheme found : " + uri);
        return MetadataDrivers.getClientDriver(schemeParts[0]);
    }

    public static MetadataBookieDriver getBookieDriver(String scheme) {
        Preconditions.checkNotNull(scheme, "Bookie Driver Scheme is null");
        MetadataBookieDriverInfo driverInfo = (MetadataBookieDriverInfo)bookieDrivers.get(scheme.toLowerCase());
        if (null == driverInfo) {
            throw new IllegalArgumentException("Unknown backend " + scheme);
        }
        return ReflectionUtils.newInstance(driverInfo.driverClass);
    }

    public static MetadataBookieDriver getBookieDriver(URI uri) {
        Preconditions.checkNotNull(uri, "Metadata service uri is null");
        String scheme = uri.getScheme();
        Preconditions.checkNotNull(scheme, "Invalid metadata service uri : " + uri);
        scheme = scheme.toLowerCase();
        String[] schemeParts = StringUtils.split(scheme, '+');
        Preconditions.checkArgument(schemeParts.length > 0, "Invalid metadata service scheme found : " + uri);
        return MetadataDrivers.getBookieDriver(schemeParts[0]);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static <T> T runFunctionWithMetadataClientDriver(ClientConfiguration conf, Function<MetadataClientDriver, T> function, ScheduledExecutorService executorService) throws MetadataException, ExecutionException {
        try {
            Throwable throwable = null;
            try (MetadataClientDriver driver = MetadataDrivers.getClientDriver(URI.create(conf.getMetadataServiceUri()));){
                MetadataClientDriver metadataClientDriver;
                driver.initialize(conf, executorService, NullStatsLogger.INSTANCE, Optional.empty());
                try {
                    metadataClientDriver = function.apply(driver);
                }
                catch (Exception uee) {
                    try {
                        if (uee.getCause() instanceof MetadataException) {
                            throw (MetadataException)uee.getCause();
                        }
                        throw new ExecutionException(uee.getMessage(), uee.getCause());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                return (T)metadataClientDriver;
            }
        }
        catch (ConfigurationException e) {
            throw new MetadataException(Code.INVALID_METADATA_SERVICE_URI, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static <T> T runFunctionWithMetadataBookieDriver(ServerConfiguration conf, Function<MetadataBookieDriver, T> function) throws MetadataException, ExecutionException {
        try {
            Throwable throwable = null;
            try (MetadataBookieDriver driver = MetadataDrivers.getBookieDriver(URI.create(conf.getMetadataServiceUri()));){
                MetadataBookieDriver metadataBookieDriver;
                driver.initialize(conf, () -> {}, NullStatsLogger.INSTANCE);
                try {
                    metadataBookieDriver = function.apply(driver);
                }
                catch (Exception uee) {
                    try {
                        if (uee.getCause() instanceof MetadataException) {
                            throw (MetadataException)uee.getCause();
                        }
                        throw new ExecutionException(uee.getMessage(), uee.getCause());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                return (T)metadataBookieDriver;
            }
        }
        catch (ConfigurationException e) {
            throw new MetadataException(Code.INVALID_METADATA_SERVICE_URI, (Throwable)e);
        }
    }

    public static <T> T runFunctionWithRegistrationManager(ServerConfiguration conf, Function<RegistrationManager, T> function) throws MetadataException, ExecutionException {
        return (T)MetadataDrivers.runFunctionWithMetadataBookieDriver(conf, driver -> function.apply(driver.getRegistrationManager()));
    }

    public static <T> T runFunctionWithLedgerManagerFactory(ServerConfiguration conf, Function<LedgerManagerFactory, T> function) throws MetadataException, ExecutionException {
        return (T)MetadataDrivers.runFunctionWithMetadataBookieDriver(conf, driver -> {
            try {
                return function.apply(driver.getLedgerManagerFactory());
            }
            catch (MetadataException me) {
                throw new UncheckedExecutionException(me.getMessage(), me);
            }
        });
    }

    private MetadataDrivers() {
    }

    static ConcurrentMap<String, MetadataClientDriverInfo> getClientDrivers() {
        return clientDrivers;
    }

    static ConcurrentMap<String, MetadataBookieDriverInfo> getBookieDrivers() {
        return bookieDrivers;
    }

    static {
        MetadataDrivers.loadInitialDrivers();
    }

    static class MetadataBookieDriverInfo {
        final Class<? extends MetadataBookieDriver> driverClass;
        final String driverClassName;

        MetadataBookieDriverInfo(Class<? extends MetadataBookieDriver> driverClass) {
            this.driverClass = driverClass;
            this.driverClassName = driverClass.getName();
        }

        public String toString() {
            return "MetadataDrivers.MetadataBookieDriverInfo(driverClass=" + this.driverClass + ", driverClassName=" + this.driverClassName + ")";
        }
    }

    static class MetadataClientDriverInfo {
        final Class<? extends MetadataClientDriver> driverClass;
        final String driverClassName;

        MetadataClientDriverInfo(Class<? extends MetadataClientDriver> driverClass) {
            this.driverClass = driverClass;
            this.driverClassName = driverClass.getName();
        }

        public String toString() {
            return "MetadataDrivers.MetadataClientDriverInfo(driverClass=" + this.driverClass + ", driverClassName=" + this.driverClassName + ")";
        }
    }
}

