/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.apache.pulsar.shade.com.google.common.primitives.Longs;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.PooledByteBufAllocator;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.api.BKException;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.api.LedgerEntry;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.api.ReadHandle;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.Entry;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl.EntryCache;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl.EntryCacheManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl.EntryImpl;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.util.RangeCache;
import org.apache.pulsar.shade.org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryCacheImpl
implements EntryCache {
    private final EntryCacheManager manager;
    private final ManagedLedgerImpl ml;
    private final RangeCache<PositionImpl, EntryImpl> entries;
    private final boolean copyEntries;
    private static final double MB = 1048576.0;
    public static final PooledByteBufAllocator ALLOCATOR = new PooledByteBufAllocator(true, 0, PooledByteBufAllocator.defaultNumDirectArena(), PooledByteBufAllocator.defaultPageSize(), PooledByteBufAllocator.defaultMaxOrder(), PooledByteBufAllocator.defaultSmallCacheSize(), PooledByteBufAllocator.defaultNormalCacheSize(), true);
    private static final Logger log = LoggerFactory.getLogger(EntryCacheImpl.class);

    public EntryCacheImpl(EntryCacheManager manager, ManagedLedgerImpl ml, boolean copyEntries) {
        this.manager = manager;
        this.ml = ml;
        this.entries = new RangeCache(EntryImpl::getLength, EntryImpl::getTimestamp);
        this.copyEntries = copyEntries;
        if (log.isDebugEnabled()) {
            log.debug("[{}] Initialized managed-ledger entry cache", (Object)ml.getName());
        }
    }

    @Override
    public String getName() {
        return this.ml.getName();
    }

    @Override
    public boolean insert(EntryImpl entry) {
        ByteBuf cachedData;
        if (!this.manager.hasSpaceInCache()) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Skipping cache while doing eviction: {} - size: {}", new Object[]{this.ml.getName(), entry.getPosition(), entry.getLength()});
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}] Adding entry to cache: {} - size: {}", new Object[]{this.ml.getName(), entry.getPosition(), entry.getLength()});
        }
        if (this.copyEntries) {
            cachedData = this.copyEntry(entry);
            if (cachedData == null) {
                return false;
            }
        } else {
            cachedData = entry.getDataBuffer().retain();
        }
        PositionImpl position = entry.getPosition();
        EntryImpl cacheEntry = EntryImpl.create(position, cachedData);
        cachedData.release();
        if (this.entries.put(position, cacheEntry)) {
            this.manager.entryAdded(entry.getLength());
            return true;
        }
        cacheEntry.release();
        return false;
    }

    private ByteBuf copyEntry(EntryImpl entry) {
        int size = entry.getLength();
        ByteBuf cachedData = null;
        try {
            cachedData = ALLOCATOR.directBuffer(size, size);
        }
        catch (Throwable t) {
            log.warn("[{}] Failed to allocate buffer for entry cache: {}", (Object)this.ml.getName(), (Object)t.getMessage());
            return null;
        }
        if (size > 0) {
            ByteBuf entryBuf = entry.getDataBuffer();
            int readerIdx = entryBuf.readerIndex();
            cachedData.writeBytes(entryBuf);
            entryBuf.readerIndex(readerIdx);
        }
        return cachedData;
    }

    @Override
    public void invalidateEntries(PositionImpl lastPosition) {
        PositionImpl firstPosition = PositionImpl.get(-1L, 0L);
        if (firstPosition.compareTo(lastPosition) > 0) {
            if (log.isDebugEnabled()) {
                log.debug("Attempted to invalidate entries in an invalid range : {} ~ {}", (Object)firstPosition, (Object)lastPosition);
            }
            return;
        }
        Pair<Integer, Long> removed = this.entries.removeRange(firstPosition, lastPosition, false);
        int entriesRemoved = removed.getLeft();
        long sizeRemoved = removed.getRight();
        if (log.isDebugEnabled()) {
            log.debug("[{}] Invalidated entries up to {} - Entries removed: {} - Size removed: {}", new Object[]{this.ml.getName(), lastPosition, entriesRemoved, sizeRemoved});
        }
        this.manager.entriesRemoved(sizeRemoved);
    }

    @Override
    public void invalidateAllEntries(long ledgerId) {
        PositionImpl firstPosition = PositionImpl.get(ledgerId, 0L);
        PositionImpl lastPosition = PositionImpl.get(ledgerId + 1L, 0L);
        Pair<Integer, Long> removed = this.entries.removeRange(firstPosition, lastPosition, false);
        int entriesRemoved = removed.getLeft();
        long sizeRemoved = removed.getRight();
        if (log.isDebugEnabled()) {
            log.debug("[{}] Invalidated all entries on ledger {} - Entries removed: {} - Size removed: {}", new Object[]{this.ml.getName(), ledgerId, entriesRemoved, sizeRemoved});
        }
        this.manager.entriesRemoved(sizeRemoved);
    }

    @Override
    public void asyncReadEntry(ReadHandle lh, PositionImpl position, AsyncCallbacks.ReadEntryCallback callback, Object ctx) {
        try {
            this.asyncReadEntry0(lh, position, callback, ctx);
        }
        catch (Throwable t) {
            log.warn("failed to read entries for {}-{}", new Object[]{lh.getId(), position, t});
            this.invalidateAllEntries(lh.getId());
            callback.readEntryFailed(ManagedLedgerImpl.createManagedLedgerException(t), ctx);
        }
    }

    private void asyncReadEntry0(ReadHandle lh, PositionImpl position, AsyncCallbacks.ReadEntryCallback callback, Object ctx) {
        EntryImpl entry;
        if (log.isDebugEnabled()) {
            log.debug("[{}] Reading entry ledger {}: {}", new Object[]{this.ml.getName(), lh.getId(), position.getEntryId()});
        }
        if ((entry = this.entries.get(position)) != null) {
            EntryImpl cachedEntry = EntryImpl.create(entry);
            entry.release();
            this.manager.mlFactoryMBean.recordCacheHit(cachedEntry.getLength());
            callback.readEntryComplete(cachedEntry, ctx);
        } else {
            ((CompletableFuture)lh.readAsync(position.getEntryId(), position.getEntryId()).thenAcceptAsync(ledgerEntries -> {
                try {
                    Iterator<LedgerEntry> iterator = ledgerEntries.iterator();
                    if (iterator.hasNext()) {
                        LedgerEntry ledgerEntry = iterator.next();
                        EntryImpl returnEntry = EntryImpl.create(ledgerEntry);
                        this.manager.mlFactoryMBean.recordCacheMiss(1, returnEntry.getLength());
                        this.ml.mbean.addReadEntriesSample(1, returnEntry.getLength());
                        callback.readEntryComplete(returnEntry, ctx);
                    } else {
                        callback.readEntryFailed(new ManagedLedgerException("Could not read given position"), ctx);
                    }
                }
                finally {
                    ledgerEntries.close();
                }
            }, (Executor)this.ml.getExecutor().chooseThread(this.ml.getName()))).exceptionally(exception -> {
                this.ml.invalidateLedgerHandle(lh);
                callback.readEntryFailed(ManagedLedgerImpl.createManagedLedgerException(exception), ctx);
                return null;
            });
        }
    }

    @Override
    public void asyncReadEntry(ReadHandle lh, long firstEntry, long lastEntry, boolean isSlowestReader, AsyncCallbacks.ReadEntriesCallback callback, Object ctx) {
        try {
            this.asyncReadEntry0(lh, firstEntry, lastEntry, isSlowestReader, callback, ctx);
        }
        catch (Throwable t) {
            log.warn("failed to read entries for {}--{}-{}", new Object[]{lh.getId(), firstEntry, lastEntry, t});
            this.invalidateAllEntries(lh.getId());
            callback.readEntriesFailed(ManagedLedgerImpl.createManagedLedgerException(t), ctx);
        }
    }

    private void asyncReadEntry0(ReadHandle lh, long firstEntry, long lastEntry, boolean isSlowestReader, AsyncCallbacks.ReadEntriesCallback callback, Object ctx) {
        Collection<EntryImpl> cachedEntries;
        long ledgerId = lh.getId();
        int entriesToRead = (int)(lastEntry - firstEntry) + 1;
        PositionImpl firstPosition = PositionImpl.get(lh.getId(), firstEntry);
        PositionImpl lastPosition = PositionImpl.get(lh.getId(), lastEntry);
        if (log.isDebugEnabled()) {
            log.debug("[{}] Reading entries range ledger {}: {} to {}", new Object[]{this.ml.getName(), ledgerId, firstEntry, lastEntry});
        }
        if ((cachedEntries = this.entries.getRange(firstPosition, lastPosition)).size() == entriesToRead) {
            long totalCachedSize = 0L;
            ArrayList<Entry> entriesToReturn = Lists.newArrayListWithExpectedSize(entriesToRead);
            for (EntryImpl entry2 : cachedEntries) {
                entriesToReturn.add(EntryImpl.create(entry2));
                totalCachedSize += (long)entry2.getLength();
                entry2.release();
            }
            this.manager.mlFactoryMBean.recordCacheHits(entriesToReturn.size(), totalCachedSize);
            if (log.isDebugEnabled()) {
                log.debug("[{}] Ledger {} -- Found in cache entries: {}-{}", new Object[]{this.ml.getName(), ledgerId, firstEntry, lastEntry});
            }
            callback.readEntriesComplete(entriesToReturn, ctx);
        } else {
            if (!cachedEntries.isEmpty()) {
                cachedEntries.forEach(entry -> entry.release());
            }
            ((CompletableFuture)lh.readAsync(firstEntry, lastEntry).thenAcceptAsync(ledgerEntries -> {
                Preconditions.checkNotNull(this.ml.getName());
                Preconditions.checkNotNull(this.ml.getExecutor());
                try {
                    long totalSize = 0L;
                    ArrayList<Entry> entriesToReturn = Lists.newArrayListWithExpectedSize(entriesToRead);
                    for (LedgerEntry e : ledgerEntries) {
                        EntryImpl entry = EntryImpl.create(e);
                        entriesToReturn.add(entry);
                        totalSize += (long)entry.getLength();
                    }
                    this.manager.mlFactoryMBean.recordCacheMiss(entriesToReturn.size(), totalSize);
                    this.ml.getMBean().addReadEntriesSample(entriesToReturn.size(), totalSize);
                    callback.readEntriesComplete(entriesToReturn, ctx);
                }
                finally {
                    ledgerEntries.close();
                }
            }, (Executor)this.ml.getExecutor().chooseThread(this.ml.getName()))).exceptionally(exception -> {
                if (exception instanceof BKException && ((BKException)exception).getCode() == -105) {
                    callback.readEntriesFailed(ManagedLedgerImpl.createManagedLedgerException(exception), ctx);
                } else {
                    this.ml.invalidateLedgerHandle(lh);
                    ManagedLedgerException mlException = ManagedLedgerImpl.createManagedLedgerException(exception);
                    callback.readEntriesFailed(mlException, ctx);
                }
                return null;
            });
        }
    }

    @Override
    public void clear() {
        long removedSize = this.entries.clear();
        this.manager.entriesRemoved(removedSize);
    }

    @Override
    public long getSize() {
        return this.entries.getSize();
    }

    @Override
    public int compareTo(EntryCache other) {
        return Longs.compare(this.getSize(), other.getSize());
    }

    @Override
    public Pair<Integer, Long> evictEntries(long sizeToFree) {
        Preconditions.checkArgument(sizeToFree > 0L);
        Pair<Integer, Long> evicted = this.entries.evictLeastAccessedEntries(sizeToFree);
        int evictedEntries = evicted.getLeft();
        long evictedSize = evicted.getRight();
        if (log.isDebugEnabled()) {
            log.debug("[{}] Doing cache eviction of at least {} Mb -- Deleted {} entries - Total size deleted: {} Mb  -- Current Size: {} Mb", new Object[]{this.ml.getName(), (double)sizeToFree / 1048576.0, evictedEntries, (double)evictedSize / 1048576.0, (double)this.entries.getSize() / 1048576.0});
        }
        this.manager.entriesRemoved(evictedSize);
        return evicted;
    }

    @Override
    public void invalidateEntriesBeforeTimestamp(long timestamp) {
        long evictedSize = this.entries.evictLEntriesBeforeTimestamp(timestamp);
        this.manager.entriesRemoved(evictedSize);
    }
}

